/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.fields.BooleanSearchValue;
import com.manydesigns.elements.fields.search.AbstractSearchField;
import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class BooleanSearchField
extends AbstractSearchField {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    protected BooleanSearchValue value = BooleanSearchValue.ANY;

    public BooleanSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public BooleanSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
    }

    @Override
    public void toSearchString(StringBuilder sb, String encoding) {
        if (this.value != null && this.value != BooleanSearchValue.ANY) {
            this.appendToSearchString(sb, this.inputName, this.value.getStringValue(), encoding);
        }
    }

    @Override
    public void configureCriteria(Criteria criteria) {
        if (this.value == null) {
            return;
        }
        switch (this.value) {
            case ANY: {
                break;
            }
            case NULL: {
                criteria.isNull(this.accessor);
                break;
            }
            case FALSE: {
                criteria.eq(this.accessor, Boolean.FALSE);
                break;
            }
            case TRUE: {
                criteria.eq(this.accessor, Boolean.TRUE);
                break;
            }
            default: {
                logger.error("Unknown BooleanSearchValue: {}", (Object)this.value.name());
            }
        }
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        String stringValue = req.getParameter(this.inputName);
        this.value = BooleanSearchValue.ANY;
        for (BooleanSearchValue current : BooleanSearchValue.values()) {
            if (!current.getStringValue().equals(stringValue)) continue;
            this.value = current;
        }
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("class", "form-group boolean-search-field");
        xb.openElement("label");
        xb.addAttribute("class", "control-label");
        xb.write(StringUtils.capitalize((String)this.label));
        xb.closeElement("label");
        xb.openElement("div");
        xb.addAttribute("class", "form-control radio ");
        for (BooleanSearchValue current : BooleanSearchValue.values()) {
            if (this.required && current == BooleanSearchValue.NULL) continue;
            String idStr = this.id + "_" + current.name();
            String stringValue = current.getStringValue();
            boolean checked = this.value == current;
            xb.writeInputRadio(idStr, this.inputName, stringValue, checked);
            xb.openElement("label");
            xb.addAttribute("for", idStr);
            String label = this.getText(current.getLabelI18N(), new Object[0]);
            xb.write(label);
            xb.closeElement("label");
            xb.write(" ");
        }
        xb.closeElement("div");
        xb.closeElement("div");
    }

    public BooleanSearchValue getValue() {
        return this.value;
    }

    public void setValue(BooleanSearchValue value) {
        this.value = value;
    }
}

