/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.annotations.DateFormat;
import com.manydesigns.elements.fields.search.RangeSearchField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.Util;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.text.MessageFormat;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringEscapeUtils;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDateSearchField
extends RangeSearchField {
    public static final String copyright = "Copyright (C) 2005-2021 ManyDesigns srl";
    protected String datePattern;
    protected DateTimeFormatter dateTimeFormatter;
    protected boolean containsTime;
    protected static final Logger logger = LoggerFactory.getLogger(AbstractDateSearchField.class);

    public AbstractDateSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public AbstractDateSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
        DateFormat dateFormatAnnotation = accessor.getAnnotation(DateFormat.class);
        if (dateFormatAnnotation != null) {
            this.datePattern = dateFormatAnnotation.value();
        } else {
            Configuration elementsConfiguration = ElementsProperties.getConfiguration();
            this.datePattern = elementsConfiguration.getString("fields.date.format");
        }
        this.dateTimeFormatter = DateTimeFormat.forPattern((String)this.datePattern);
        this.setSize(this.dateTimeFormatter.getParser().estimateParsedLength());
        this.containsTime = this.datePattern.contains("HH") || this.datePattern.contains("mm") || this.datePattern.contains("ss");
    }

    @Override
    public void rangeEndToXhtml(XhtmlBuffer xb, String id, String inputName, String stringValue, String label) {
        String js = MessageFormat.format("$(function() '{' setupDatePicker(''#{0}'', ''{1}''); '}');", StringEscapeUtils.escapeJavaScript((String)id), StringEscapeUtils.escapeJavaScript((String)this.datePattern));
        xb.writeJavaScript(js);
        super.rangeEndToXhtml(xb, id, inputName, stringValue, label);
    }

    @Override
    protected Object readValue(String stringValue, Class type) {
        Object value;
        try {
            value = this.toDate(Util.parseDateTime(this.dateTimeFormatter, stringValue, this.containsTime));
        }
        catch (Exception e) {
            logger.debug("Value not parseable", (Throwable)e);
            try {
                value = this.toDate(new DateTime((Object)Long.valueOf(stringValue)));
            }
            catch (Exception ex) {
                logger.debug("Value is not a date representation", (Throwable)ex);
                value = null;
            }
        }
        return value;
    }

    protected abstract Object toDate(DateTime var1);

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    public DateTimeFormatter getDateTimeFormatter() {
        return this.dateTimeFormatter;
    }

    public void setDateTimeFormatter(DateTimeFormatter dateTimeFormatter) {
        this.dateTimeFormatter = dateTimeFormatter;
    }

    public boolean isContainsTime() {
        return this.containsTime;
    }

    public void setContainsTime(boolean containsTime) {
        this.containsTime = containsTime;
    }
}

