/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.blobs;

import com.manydesigns.crypto.CryptoService;
import com.manydesigns.elements.FormElement;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.fields.AbstractBlobField;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.forms.TableForm;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BlobUtils {
    public static final Logger logger = LoggerFactory.getLogger(BlobUtils.class);

    public static void loadBlobs(Form form, BlobManager blobManager, boolean loadContents) {
        for (FieldSet fieldSet : form) {
            BlobUtils.loadBlobs(fieldSet, blobManager, loadContents);
        }
    }

    public static void loadBlobs(FieldSet fieldSet, BlobManager blobManager, boolean loadContents) {
        for (FormElement field : fieldSet) {
            BlobUtils.loadBlob(field, blobManager, loadContents);
        }
    }

    public static void loadBlobs(TableForm form, BlobManager blobManager, boolean loadContents) {
        for (TableForm.Row row : form.getRows()) {
            BlobUtils.loadBlobs(row, blobManager, loadContents);
        }
    }

    public static void loadBlobs(TableForm.Row row, BlobManager blobManager, boolean loadContents) {
        for (FormElement field : row) {
            BlobUtils.loadBlob(field, blobManager, loadContents);
        }
    }

    public static void loadBlob(FormElement field, BlobManager blobManager, boolean loadContents) {
        if (AbstractBlobField.class.isInstance(field)) {
            AbstractBlobField blobField = (AbstractBlobField)AbstractBlobField.class.cast(field);
            blobField.loadBlob(blobManager, loadContents);
        }
    }

    public static void saveBlobs(Form form, BlobManager blobManager) throws IOException {
        for (FieldSet fieldSet : form) {
            BlobUtils.saveBlobs(fieldSet, blobManager);
        }
    }

    public static void saveBlobs(FieldSet fieldSet, BlobManager blobManager) throws IOException {
        for (FormElement field : fieldSet) {
            AbstractBlobField blobField;
            Blob blob;
            if (!AbstractBlobField.class.isInstance(field) || (blob = (blobField = (AbstractBlobField)AbstractBlobField.class.cast(field)).getValue()) == null || blob.getCode() == null || blob.getInputStream() == null) continue;
            blobManager.save(blob);
        }
    }

    public static InputStream encrypt(InputStream decryptedInputStream, String type) {
        try {
            logger.debug("Decrypting encryptedInputStream");
            return CryptoService.getInstance().encrypt(decryptedInputStream);
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return decryptedInputStream;
        }
    }

    public static InputStream decrypt(InputStream encryptedInputStream, String type) {
        try {
            logger.debug("Decrypting encryptedInputStream");
            return CryptoService.getInstance().decrypt(encryptedInputStream);
        }
        catch (IOException | GeneralSecurityException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return encryptedInputStream;
        }
    }

    public static Long calculatePaddingSize(Blob blob) {
        logger.debug("Calculating padding size");
        return CryptoService.getInstance().getFileSize(Long.valueOf(blob.getSize()));
    }
}

