/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.text;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.text.AbstractOgnlFormat;
import com.manydesigns.elements.text.TextFormat;
import com.manydesigns.elements.util.Util;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlTextFormat
extends AbstractOgnlFormat
implements TextFormat {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected boolean url = false;
    protected String encoding = "ISO-8859-1";
    protected Locale locale;
    public static final Logger logger = LoggerFactory.getLogger(OgnlTextFormat.class);

    public static OgnlTextFormat create(String ognlFormat) {
        return new OgnlTextFormat(ognlFormat);
    }

    public static String format(String expression, Object root) {
        return OgnlTextFormat.create(expression).format(root);
    }

    public OgnlTextFormat(String ognlFormat) {
        super(ognlFormat);
    }

    @Override
    public String format(Object root) {
        Object[] args = this.evaluateOgnlExpressions(root);
        String[] argStrings = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            String argString = OgnlUtils.convertValue(arg, String.class);
            if (argString == null) {
                argStrings[i] = null;
                continue;
            }
            try {
                argStrings[i] = this.url ? URLEncoder.encode(argString, this.encoding) : argString;
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        Locale locale = this.locale;
        if (locale == null) {
            HttpServletRequest req = ElementsThreadLocals.getHttpServletRequest();
            locale = req != null ? req.getLocale() : Locale.getDefault();
        }
        String result = new MessageFormat(this.getFormatString(), locale).format(argStrings);
        if (this.url) {
            result = Util.getAbsoluteUrl(result);
        }
        return result;
    }

    @Override
    protected String escapeText(String text) {
        return text.replace("'", "''").replace("{", "'{'");
    }

    @Override
    protected void replaceOgnlExpression(StringBuilder sb, int index, String ognlExpression) {
        sb.append("{");
        sb.append(index);
        sb.append("}");
    }

    public boolean isUrl() {
        return this.url;
    }

    public void setUrl(boolean url) {
        this.url = url;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }
}

