/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields.search;

import com.manydesigns.elements.fields.search.AbstractSearchField;
import com.manydesigns.elements.fields.search.Criteria;
import com.manydesigns.elements.ognl.OgnlUtils;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;

public class RangeSearchField
extends AbstractSearchField {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    public static final String MIN_SUFFIX = "_min";
    public static final String MAX_SUFFIX = "_max";
    public static final String NULL_VALUE = "-";
    protected String minId = this.id + "_min";
    protected String minInputName = this.inputName + "_min";
    protected String minStringValue;
    protected Object minValue;
    protected String maxId = this.id + "_max";
    protected String maxInputName = this.inputName + "_max";
    protected String maxStringValue;
    protected Object maxValue;
    protected Integer size = 4;
    protected Integer maxLength = null;
    protected boolean searchNullValue;

    public RangeSearchField(PropertyAccessor accessor) {
        this(accessor, null);
    }

    public RangeSearchField(PropertyAccessor accessor, String prefix) {
        super(accessor, prefix);
    }

    @Override
    public void toXhtml(@NotNull XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("class", "form-group");
        xb.openElement("div");
        xb.addAttribute("class", "input-group");
        xb.openElement("label");
        xb.addAttribute("class", "control-label input-group-addon");
        xb.write(StringUtils.capitalize((String)this.label));
        xb.closeElement("label");
        this.rangeEndToXhtml(xb, this.minId, this.minInputName, this.minStringValue, this.getText("elements.search.range.from", new Object[0]));
        this.rangeEndToXhtml(xb, this.maxId, this.maxInputName, this.maxStringValue, this.getText("elements.search.range.to", new Object[0]));
        xb.closeElement("div");
        xb.closeElement("div");
    }

    public void rangeEndToXhtml(XhtmlBuffer xb, String id, String inputName, String stringValue, String label) {
        xb.openElement("label");
        xb.addAttribute("class", "input-group-addon");
        xb.addAttribute("for", id);
        xb.write(label);
        xb.closeElement("label");
        xb.writeInputText(id, inputName, stringValue, "form-control", this.size, this.maxLength);
        xb.write(" ");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        Class type = this.accessor.getType();
        this.minStringValue = StringUtils.trimToNull((String)req.getParameter(this.minInputName));
        try {
            this.minValue = OgnlUtils.convertValue(this.minStringValue, type);
        }
        catch (Throwable e) {
            this.minValue = null;
        }
        this.maxStringValue = StringUtils.trimToNull((String)req.getParameter(this.maxInputName));
        try {
            this.maxValue = OgnlUtils.convertValue(this.maxStringValue, type);
        }
        catch (Throwable e) {
            this.maxValue = null;
        }
        this.searchNullValue = NULL_VALUE.equals(this.minStringValue) || NULL_VALUE.equals(this.maxStringValue);
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void toSearchString(StringBuilder sb, String encoding) {
        if (this.minStringValue != null) {
            this.appendToSearchString(sb, this.minInputName, this.minStringValue, encoding);
        }
        if (this.maxStringValue != null) {
            this.appendToSearchString(sb, this.maxInputName, this.maxStringValue, encoding);
        }
    }

    @Override
    public void configureCriteria(Criteria criteria) {
        if (this.searchNullValue) {
            criteria.isNull(this.accessor);
        } else if (this.minValue != null && this.maxValue != null) {
            criteria.between(this.accessor, this.minValue, this.maxValue);
        } else if (this.minValue != null) {
            criteria.ge(this.accessor, this.minValue);
        } else if (this.maxValue != null) {
            criteria.le(this.accessor, this.maxValue);
        }
    }

    public String getMinId() {
        return this.minId;
    }

    public void setMinId(String minId) {
        this.minId = minId;
    }

    public String getMinInputName() {
        return this.minInputName;
    }

    public void setMinInputName(String minInputName) {
        this.minInputName = minInputName;
    }

    public String getMinStringValue() {
        return this.minStringValue;
    }

    public void setMinStringValue(String minStringValue) {
        this.minStringValue = minStringValue;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Object minValue) {
        this.minValue = minValue;
    }

    public String getMaxId() {
        return this.maxId;
    }

    public void setMaxId(String maxId) {
        this.maxId = maxId;
    }

    public String getMaxInputName() {
        return this.maxInputName;
    }

    public void setMaxInputName(String maxInputName) {
        this.maxInputName = maxInputName;
    }

    public String getMaxStringValue() {
        return this.maxStringValue;
    }

    public void setMaxStringValue(String maxStringValue) {
        this.maxStringValue = maxStringValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Object maxValue) {
        this.maxValue = maxValue;
    }

    public boolean isSearchNullValue() {
        return this.searchNullValue;
    }

    public void setSearchNullValue(boolean searchNullValue) {
        this.searchNullValue = searchNullValue;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }
}

