/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.forms;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.annotations.Enabled;
import com.manydesigns.elements.fields.Field;
import com.manydesigns.elements.fields.SelectField;
import com.manydesigns.elements.forms.AbstractFormBuilder;
import com.manydesigns.elements.forms.FieldSet;
import com.manydesigns.elements.forms.Form;
import com.manydesigns.elements.options.SelectionModel;
import com.manydesigns.elements.options.SelectionProvider;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaClassAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class FormBuilder
extends AbstractFormBuilder {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final int DEFAULT_N_COLUMNS = 1;
    protected List<ArrayList<PropertyAccessor>> groupedPropertyAccessors;
    protected List<String> fieldSetNames;
    protected String prefix;
    protected int nColumns = 1;
    protected Mode mode = Mode.EDIT;

    public FormBuilder(Class aClass) {
        this(JavaClassAccessor.getClassAccessor(aClass));
    }

    public FormBuilder(ClassAccessor classAccessor) {
        super(classAccessor);
    }

    public FormBuilder configFields(String ... fieldNames) {
        logger.debug("Configuring fields to: {}", (Object[])fieldNames);
        String[][] groupedFieldNames = new String[][]{fieldNames};
        return this.configFields(groupedFieldNames);
    }

    public FormBuilder configFields(String[] ... groupedFieldNames) {
        logger.debug("configFields", (Object[])groupedFieldNames);
        this.groupedPropertyAccessors = new ArrayList<ArrayList<PropertyAccessor>>();
        for (String[] currentNameGroup : groupedFieldNames) {
            ArrayList<PropertyAccessor> currentPropertyGroup = new ArrayList<PropertyAccessor>();
            this.groupedPropertyAccessors.add(currentPropertyGroup);
            for (String currentField : currentNameGroup) {
                try {
                    PropertyAccessor accessor = this.classAccessor.getProperty(currentField);
                    currentPropertyGroup.add(accessor);
                }
                catch (NoSuchFieldException e) {
                    logger.warn("Field not found: {}" + currentField, (Throwable)e);
                }
            }
        }
        return this;
    }

    public FormBuilder configPrefix(String prefix) {
        logger.debug("Configuring prefix to: ", (Object)prefix);
        this.prefix = prefix;
        return this;
    }

    public FormBuilder configNColumns(int nColumns) {
        logger.debug("Configuring nColumns to: {}", (Object)nColumns);
        this.nColumns = nColumns;
        return this;
    }

    public FormBuilder configFieldSetNames(String ... fieldSetNames) {
        logger.debug("Configuring configFieldSetNames to: {}", (Object[])fieldSetNames);
        this.fieldSetNames = Arrays.asList(fieldSetNames);
        return this;
    }

    public FormBuilder configSelectionProvider(SelectionProvider selectionProvider, String ... fieldNames) {
        this.selectionProviders.put(fieldNames, selectionProvider);
        return this;
    }

    public FormBuilder configMode(Mode mode) {
        this.mode = mode;
        return this;
    }

    public FormBuilder configReflectiveFields() {
        logger.debug("configReflectiveFields");
        this.groupedPropertyAccessors = new ArrayList<ArrayList<PropertyAccessor>>();
        this.fieldSetNames = new ArrayList<String>();
        ArrayList<PropertyAccessor> currentGroup = null;
        String currentGroupName = null;
        for (PropertyAccessor current : this.classAccessor.getProperties()) {
            Enabled enabled = current.getAnnotation(Enabled.class);
            if (enabled != null && !enabled.value()) {
                logger.debug("Skipping non-enabled field: {}", (Object)current.getName());
                continue;
            }
            String groupName = null;
            if (current.isAnnotationPresent(com.manydesigns.elements.annotations.FieldSet.class)) {
                groupName = this.getText(current.getAnnotation(com.manydesigns.elements.annotations.FieldSet.class).value(), new Object[0]);
            }
            if (currentGroup == null || groupName != null && !groupName.equals(currentGroupName)) {
                currentGroup = new ArrayList<PropertyAccessor>();
                this.groupedPropertyAccessors.add(currentGroup);
                this.fieldSetNames.add(groupName);
                currentGroupName = groupName;
            }
            currentGroup.add(current);
        }
        logger.debug("configReflectiveFields");
        return this;
    }

    public Form build() {
        logger.debug("build");
        Form form = new Form(this.mode);
        if (this.groupedPropertyAccessors == null) {
            this.configReflectiveFields();
        }
        ArrayList<PropertyAccessor> allPropertyAccessors = new ArrayList<PropertyAccessor>();
        for (ArrayList<PropertyAccessor> group : this.groupedPropertyAccessors) {
            allPropertyAccessors.addAll(group);
        }
        this.removeUnusedSelectionProviders(allPropertyAccessors);
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (int i = 0; i < this.groupedPropertyAccessors.size(); ++i) {
            this.buildFieldGroup(form, i, fieldMap);
        }
        for (Map.Entry current : this.selectionProviders.entrySet()) {
            String[] fieldNames = (String[])current.getKey();
            SelectionProvider selectionProvider = (SelectionProvider)current.getValue();
            SelectionModel selectionModel = selectionProvider.createSelectionModel();
            SelectField previousField = null;
            for (int i = 0; i < fieldNames.length; ++i) {
                SelectField selectField = (SelectField)fieldMap.get(fieldNames[i]);
                selectField.setSelectionModel(selectionModel);
                selectField.setSelectionModelIndex(i);
                if (previousField != null) {
                    selectField.setPreviousSelectField(previousField);
                    previousField.setNextSelectField(selectField);
                }
                previousField = selectField;
            }
        }
        return form;
    }

    protected void buildFieldGroup(Form form, int i, Map<String, Field> fieldMap) {
        ArrayList<PropertyAccessor> group = this.groupedPropertyAccessors.get(i);
        String fieldSetName = this.fieldSetNames == null ? null : this.fieldSetNames.get(i);
        FieldSet fieldSet = new FieldSet(fieldSetName, this.nColumns, this.mode);
        form.add(fieldSet);
        for (PropertyAccessor propertyAccessor : group) {
            this.buildField(fieldSet, propertyAccessor, fieldMap);
        }
    }

    protected void buildField(FieldSet fieldSet, PropertyAccessor propertyAccessor, Map<String, Field> fieldMap) {
        Field field = this.buildField(propertyAccessor);
        if (field != null) {
            fieldSet.add(field);
            fieldMap.put(propertyAccessor.getName(), field);
        }
    }

    protected Field buildField(PropertyAccessor propertyAccessor) {
        Field field = null;
        String fieldName = propertyAccessor.getName();
        for (Map.Entry current : this.selectionProviders.entrySet()) {
            Object[] fieldNames = (String[])current.getKey();
            int index = ArrayUtils.indexOf((Object[])fieldNames, (Object)fieldName);
            if (index < 0) continue;
            field = new SelectField(propertyAccessor, (SelectionProvider)current.getValue(), this.mode, this.prefix);
            break;
        }
        if (field == null) {
            field = this.manager.tryToInstantiateField(this.classAccessor, propertyAccessor, this.mode, this.prefix);
        }
        if (field == null) {
            logger.warn("Cannot instanciate field for property {}", (Object)propertyAccessor);
        }
        return field;
    }

    public String getText(String key, Object ... args) {
        return ElementsThreadLocals.getTextProvider().getText(key, args);
    }
}

