/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.Mode;
import com.manydesigns.elements.fields.AbstractField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.xml.XhtmlBuffer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.BooleanUtils;

public class BooleanField
extends AbstractField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String CHECK_PREFIX = "__checkbox_";
    public static final String CHECK_VALUE = "true";
    public static final String NULL_VALUE = null;
    public static final String NULL_LABEL_I18N = "elements.null";
    public static final String TRUE_VALUE = "true";
    public static final String TRUE_LABEL_I18N = "elements.Yes";
    public static final String FALSE_VALUE = "false";
    public static final String FALSE_LABEL_I18N = "elements.No";
    protected Boolean booleanValue;
    protected String checkInputName;

    public BooleanField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public BooleanField(PropertyAccessor accessor, Mode mode, String prefix) {
        super(accessor, mode, prefix);
        Class type = accessor.getType();
        if (type.isPrimitive()) {
            this.setRequired(true);
        }
        this.checkInputName = CHECK_PREFIX + this.inputName;
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String stringValue = req.getParameter(this.inputName);
        String checkValue = req.getParameter(this.checkInputName);
        if (stringValue == null && checkValue == null) {
            return;
        }
        this.booleanValue = "true".equals(stringValue) ? Boolean.valueOf(true) : (FALSE_VALUE.equals(stringValue) ? Boolean.valueOf(false) : (this.required ? Boolean.valueOf(false) : null));
    }

    @Override
    public boolean validate() {
        return true;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        this.booleanValue = obj == null ? null : (Boolean)this.accessor.get(obj);
    }

    @Override
    public void writeToObject(Object obj) {
        this.writeToObject(obj, this.booleanValue);
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb);
        } else if (this.mode.isHidden()) {
            this.valueToXhtmlHidden(xb);
        } else {
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
        }
    }

    protected void valueToXhtmlEdit(XhtmlBuffer xb) {
        if (this.required) {
            xb.openElement("div");
            xb.addAttribute("class", "checkbox");
            xb.openElement("label");
            xb.addAttribute("class", "checkbox-inline");
            xb.writeInputCheckbox(this.id, this.inputName, "true", BooleanUtils.isTrue((Boolean)this.booleanValue), false, null);
            xb.writeInputHidden(this.checkInputName, "true");
            xb.closeElement("label");
            xb.closeElement("div");
        } else {
            xb.openElement("select");
            xb.addAttribute("id", this.id);
            xb.addAttribute("name", this.inputName);
            xb.writeOption(NULL_VALUE, this.booleanValue == null, this.getText(NULL_LABEL_I18N, new Object[0]));
            xb.writeOption("true", BooleanUtils.isTrue((Boolean)this.booleanValue), this.getText(TRUE_LABEL_I18N, new Object[0]));
            xb.writeOption(FALSE_VALUE, BooleanUtils.isFalse((Boolean)this.booleanValue), this.getText(FALSE_LABEL_I18N, new Object[0]));
            xb.closeElement("select");
        }
        if (this.mode.isBulk()) {
            xb.writeJavaScript("$(function() { configureBulkEditField('" + this.id + "', '" + this.bulkCheckboxName + "'); " + "});");
        }
    }

    protected void valueToXhtmlHidden(XhtmlBuffer xb) {
        xb.writeInputHidden(this.inputName, this.getStringValue());
        xb.writeInputHidden(this.checkInputName, "true");
    }

    protected void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        this.valueToXhtmlHidden(xb);
    }

    protected void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("p");
        xb.addAttribute("class", "form-control-static");
        xb.addAttribute("id", this.id);
        if (this.href != null) {
            xb.openElement("a");
            xb.addAttribute("href", this.href);
        }
        xb.write(this.getDisplayValue());
        if (this.href != null) {
            xb.closeElement("a");
        }
        xb.closeElement("p");
    }

    @Override
    public String getStringValue() {
        if (this.booleanValue == null) {
            return NULL_VALUE;
        }
        if (this.booleanValue.booleanValue()) {
            return "true";
        }
        return FALSE_VALUE;
    }

    @Override
    public String getDisplayValue() {
        String labelI18N = this.booleanValue == null ? NULL_LABEL_I18N : (this.booleanValue != false ? TRUE_LABEL_I18N : FALSE_LABEL_I18N);
        return this.getText(labelI18N, new Object[0]);
    }

    @Override
    public Boolean getValue() {
        return this.booleanValue;
    }

    public void setValue(Boolean booleanValue) {
        this.booleanValue = booleanValue;
    }
}

