/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.util;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ReflectionUtil.class);

    public static Class loadClass(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            logger.debug("Loaded class: {}", aClass);
            return aClass;
        }
        catch (Throwable e) {
            logger.debug("Could not load class: {}", (Object)className);
            return null;
        }
    }

    public static Constructor getConstructor(String className, Class ... argClasses) {
        return ReflectionUtil.getConstructor(ReflectionUtil.loadClass(className), argClasses);
    }

    public static Constructor getConstructor(Class aClass, Class ... argClasses) {
        try {
            Constructor constructor = aClass.getConstructor(argClasses);
            logger.debug("Found constructor: {}", constructor);
            return constructor;
        }
        catch (Throwable e) {
            logger.debug("Could not find construtor for class: {}", (Object)aClass);
            return null;
        }
    }

    public static Constructor getBestMatchConstructor(Class aClass, Class ... argClasses) {
        for (Constructor<?> current : aClass.getConstructors()) {
            Class<?>[] parameterTypes = current.getParameterTypes();
            if (parameterTypes.length != argClasses.length) continue;
            boolean matches = true;
            for (int i = 0; i < argClasses.length; ++i) {
                Class<?> paramaterType = parameterTypes[i];
                Class argClass = argClasses[i];
                matches = matches && paramaterType.isAssignableFrom(argClass);
            }
            if (!matches) continue;
            return current;
        }
        logger.debug("Could not find best match construtor for class: {}", (Object)aClass);
        return null;
    }

    public static Object newInstance(String className) {
        return ReflectionUtil.newInstance(ReflectionUtil.loadClass(className));
    }

    public static Object newInstance(Class aClass) {
        Constructor constructor = ReflectionUtil.getConstructor(aClass, new Class[0]);
        return ReflectionUtil.newInstance(constructor, new Object[0]);
    }

    public static Object newInstance(Constructor constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable e) {
            logger.debug("Could not instanciate class constructor: {}", (Object)constructor);
            return null;
        }
    }

    public static InputStream getResourceAsStream(String resourceName) {
        return ReflectionUtil.class.getClassLoader().getResourceAsStream(resourceName);
    }
}

