/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.xml;

import com.manydesigns.elements.xml.IOError;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.EmptyStackException;
import java.util.Stack;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringEscapeUtils;

public class XmlBuffer {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    private static final int TEXT = 3;
    private static final int START = 0;
    private static final int OPEN = 2;
    private static final int CLOSE = 1;
    public static boolean checkWellFormed = false;
    public static String[] DEFAULT_EMPTY_TAG_ALLOWED_LIST = new String[0];
    protected final Writer writer;
    protected int state;
    protected final Stack<String> tagStack;
    protected String[] allowedEmptyTags;

    public XmlBuffer() {
        this(new StringWriter());
    }

    public XmlBuffer(Writer writer) {
        this.writer = writer;
        this.state = 0;
        this.tagStack = checkWellFormed ? new Stack() : null;
        this.allowedEmptyTags = DEFAULT_EMPTY_TAG_ALLOWED_LIST;
    }

    public void addAttribute(String name, String value) {
        try {
            switch (this.state) {
                case 2: {
                    if (value != null) {
                        this.writer.write(" ");
                        this.writer.write(name);
                        this.writer.write("=\"");
                        this.writer.write(this.escape(value));
                        this.writer.write("\"");
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void adjust() {
        try {
            switch (this.state) {
                case 2: {
                    this.writer.write(">");
                    this.state = 3;
                }
                case 0: 
                case 1: 
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void closeElement(String name) {
        if (this.tagStack != null) {
            String topOfStack;
            try {
                topOfStack = this.tagStack.pop();
            }
            catch (EmptyStackException e) {
                throw new IllegalStateException("Stack underflow: " + this.writer.toString(), e);
            }
            if (!topOfStack.equals(name)) {
                throw new IllegalStateException(MessageFormat.format("Expected: {0} - Actual: {1}\n{2}", topOfStack, name, this.writer.toString()));
            }
        }
        try {
            switch (this.state) {
                case 2: {
                    if (ArrayUtils.contains((Object[])this.allowedEmptyTags, (Object)name)) {
                        this.writer.write(" />");
                        break;
                    }
                    this.writer.write(">");
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                    break;
                }
                case 1: 
                case 3: {
                    this.writer.write("</");
                    this.writer.write(name);
                    this.writer.write(">");
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            this.state = 1;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void openElement(String name) {
        try {
            switch (this.state) {
                case 2: {
                    this.writer.write(">");
                }
                case 0: 
                case 1: 
                case 3: {
                    this.writer.write("<");
                    this.writer.write(name);
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            this.state = 2;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (this.tagStack != null) {
            this.tagStack.push(name);
        }
    }

    public void write(String text) {
        this.writeNoHtmlEscape(this.escape(text));
    }

    public void write(XmlBuffer buffer) {
        try {
            switch (this.state) {
                case 2: {
                    this.adjust();
                }
                case 0: 
                case 1: 
                case 3: {
                    if (buffer == null) break;
                    this.writer.write(buffer.writer.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            if (buffer != null && buffer.state != 0) {
                this.state = buffer.state;
                if (this.tagStack != null) {
                    this.tagStack.addAll(buffer.tagStack);
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void writeXmlHeader(String encoding) {
        try {
            switch (this.state) {
                case 0: {
                    this.writer.write("<?xml version=\"1.0\" encoding=\"");
                    this.writer.write(encoding);
                    this.writer.write("\"?>");
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            this.state = 1;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void writeDoctype(String first, String second, String third, String fourth) {
        try {
            switch (this.state) {
                case 0: {
                    this.writer.write("<!DOCTYPE ");
                    this.writer.write(first);
                    this.writer.write(" ");
                    this.writer.write(second);
                    this.writer.write(" \"");
                    this.writer.write(third);
                    this.writer.write("\" \"");
                    this.writer.write(fourth);
                    this.writer.write("\">\n");
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            this.state = 1;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public void writeNoHtmlEscape(String text) {
        try {
            switch (this.state) {
                case 2: {
                    this.writer.write(">");
                }
                case 0: 
                case 1: 
                case 3: {
                    if (text == null) break;
                    this.writer.write(text);
                    break;
                }
                default: {
                    throw new IllegalStateException("XmlBuffer state " + this.state);
                }
            }
            this.state = 3;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    public String toString() {
        String result = this.writer.toString();
        if (this.tagStack != null && !this.tagStack.empty()) {
            throw new IllegalStateException("Stack not empty: " + result);
        }
        return result;
    }

    public String getXml() {
        return this.toString();
    }

    public String escape(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    public String[] getAllowedEmptyTags() {
        return this.allowedEmptyTags;
    }

    public void setAllowedEmptyTags(String[] allowedEmptyTags) {
        this.allowedEmptyTags = allowedEmptyTags;
    }
}

