/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.servlet;

import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletUtils {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(ServletUtils.class);
    public static final long ONE_YEAR_MILLIS = 31536000000L;

    public static void dumpRequestAttributes(HttpServletRequest request) {
        Enumeration attNames = request.getAttributeNames();
        while (attNames.hasMoreElements()) {
            String attrName = (String)attNames.nextElement();
            Object attrValue = request.getAttribute(attrName);
            logger.info("{} = {}", (Object)attrName, attrValue);
        }
    }

    public static String getPath(HttpServletRequest request) {
        String contextPath;
        String path = request.getRequestURI();
        if (path.startsWith(contextPath = request.getContextPath())) {
            path = path.substring(contextPath.length());
        }
        return path;
    }

    public static String getApplicationBaseUrl(HttpServletRequest req) {
        String scheme = req.getScheme();
        int port = req.getServerPort();
        String portString = scheme.equals("http") && port == 80 || scheme.equals("https") && port == 443 ? "" : ":" + port;
        return scheme + "://" + req.getServerName() + portString + req.getContextPath();
    }

    public static void markCacheableForever(HttpServletResponse response) {
        long expiresAfterMillis = System.currentTimeMillis() + 31536000000L;
        response.setHeader("Pragma", "");
        response.setDateHeader("Expires", expiresAfterMillis);
        response.setHeader("Cache-Control", "private");
        response.addHeader("Cache-Control", "max-age=31536000000");
    }
}

