/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.fields;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.Mode;
import com.manydesigns.elements.blobs.Blob;
import com.manydesigns.elements.blobs.BlobManager;
import com.manydesigns.elements.fields.AbstractField;
import com.manydesigns.elements.fields.MultipartRequestField;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.MemoryUtil;
import com.manydesigns.elements.util.RandomUtil;
import com.manydesigns.elements.xml.XhtmlBuffer;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.FileBean;
import net.sourceforge.stripes.controller.StripesRequestWrapper;
import org.apache.commons.lang.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBlobField
extends AbstractField
implements MultipartRequestField {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String UPLOAD_KEEP = "_keep";
    public static final String UPLOAD_MODIFY = "_modify";
    public static final String UPLOAD_DELETE = "_delete";
    public static final String OPERATION_SUFFIX = "_operation";
    public static final String CODE_SUFFIX = "_code";
    public static final String INNER_SUFFIX = "_inner";
    protected String innerId;
    protected String operationInputName;
    protected String codeInputName;
    protected Blob blob;
    protected String blobError;

    public FileBlobField(PropertyAccessor accessor, Mode mode) {
        this(accessor, mode, null);
    }

    public FileBlobField(@NotNull PropertyAccessor accessor, @NotNull Mode mode, @Nullable String prefix) {
        super(accessor, mode, prefix);
        this.innerId = this.id + INNER_SUFFIX;
        this.operationInputName = this.inputName + OPERATION_SUFFIX;
        this.codeInputName = this.inputName + CODE_SUFFIX;
    }

    @Override
    public void valueToXhtml(XhtmlBuffer xb) {
        if (this.mode.isView(this.insertable, this.updatable)) {
            this.valueToXhtmlView(xb);
        } else if (this.mode.isEdit()) {
            this.valueToXhtmlEdit(xb);
        } else if (this.mode.isPreview()) {
            this.valueToXhtmlPreview(xb);
        } else if (this.mode.isHidden()) {
            this.valueToXhtmlHidden(xb);
        } else {
            throw new IllegalStateException("Unknown mode: " + (Object)((Object)this.mode));
        }
    }

    @Override
    public String getStringValue() {
        if (this.blob == null) {
            return null;
        }
        return this.blob.getFilename();
    }

    public void valueToXhtmlPreview(XhtmlBuffer xb) {
        this.valueToXhtmlView(xb);
        this.valueToXhtmlHidden(xb);
    }

    private void valueToXhtmlHidden(XhtmlBuffer xb) {
        xb.writeInputHidden(this.operationInputName, UPLOAD_KEEP);
        if (this.blob != null) {
            xb.writeInputHidden(this.codeInputName, this.blob.getCode());
        }
    }

    public void valueToXhtmlView(XhtmlBuffer xb) {
        xb.openElement("div");
        xb.addAttribute("id", this.id);
        xb.addAttribute("class", "value");
        if (this.blobError != null) {
            xb.openElement("div");
            xb.addAttribute("class", "blob-error");
            xb.write(this.blobError);
            xb.closeElement("div");
        } else if (this.blob != null) {
            this.writeBlobFilenameAndSize(xb);
        }
        xb.closeElement("div");
    }

    public void writeBlobFilenameAndSize(XhtmlBuffer xb) {
        if (this.href != null) {
            xb.openElement("a");
            xb.addAttribute("href", this.href);
        }
        xb.write(this.blob.getFilename());
        if (this.href != null) {
            xb.closeElement("a");
        }
        xb.write(" (");
        xb.write(MemoryUtil.bytesToHumanString(this.blob.getSize()));
        xb.write(")");
    }

    private void valueToXhtmlEdit(XhtmlBuffer xb) {
        if (this.blob == null) {
            xb.writeInputHidden(this.operationInputName, UPLOAD_MODIFY);
            xb.writeInputFile(this.id, this.inputName, false);
        } else {
            xb.openElement("div");
            xb.addAttribute("class", "value");
            xb.addAttribute("id", this.id);
            xb.openElement("div");
            this.writeBlobFilenameAndSize(xb);
            xb.closeElement("div");
            String radioId = this.id + UPLOAD_KEEP;
            String script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');" + "inptxt.disabled=true;inptxt.value='';";
            this.printRadio(xb, radioId, "elements.field.upload.keep", UPLOAD_KEEP, true, script);
            radioId = this.id + UPLOAD_MODIFY;
            script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');" + "inptxt.disabled=false;inptxt.value='';";
            this.printRadio(xb, radioId, "elements.field.upload.update", UPLOAD_MODIFY, false, script);
            if (!this.isRequired()) {
                radioId = this.id + UPLOAD_DELETE;
                script = "var inptxt = this.ownerDocument.getElementById('" + StringEscapeUtils.escapeJavaScript((String)this.innerId) + "');" + "inptxt.disabled=true;inptxt.value='';";
                this.printRadio(xb, radioId, "elements.field.upload.delete", UPLOAD_DELETE, false, script);
            }
            xb.writeInputFile(this.innerId, this.inputName, true);
            xb.writeInputHidden(this.codeInputName, this.blob.getCode());
            xb.closeElement("div");
        }
    }

    protected void printRadio(XhtmlBuffer xb, String radioId, String labelKey, String value, boolean checked, String script) {
        xb.openElement("label");
        xb.addAttribute("for", radioId);
        xb.addAttribute("class", "radio");
        xb.writeInputRadio(radioId, this.operationInputName, value, checked, false, script);
        xb.writeNbsp();
        xb.write(this.getText(labelKey, new Object[0]));
        xb.closeElement("label");
    }

    @Override
    public void readFromRequest(HttpServletRequest req) {
        super.readFromRequest(req);
        if (this.mode.isView(this.insertable, this.updatable)) {
            return;
        }
        String updateTypeStr = req.getParameter(this.operationInputName);
        if (UPLOAD_MODIFY.equals(updateTypeStr)) {
            this.saveUpload(req);
        } else if (UPLOAD_DELETE.equals(updateTypeStr)) {
            this.blob = null;
        } else {
            String code = req.getParameter(this.codeInputName);
            this.safeLoadBlob(code);
        }
    }

    private void saveUpload(HttpServletRequest req) {
        BlobManager blobManager = ElementsThreadLocals.getBlobManager();
        if (blobManager == null) {
            logger.warn("No blob manager found. Cannot save upload.");
            throw new Error("No blob manager found. Cannot save upload.");
        }
        FileBean fileBean = null;
        try {
            StripesRequestWrapper stripesRequest = StripesRequestWrapper.findStripesWrapper((ServletRequest)req);
            fileBean = stripesRequest.getFileParameterValue(this.inputName);
            if (fileBean != null) {
                String code = RandomUtil.createRandomId();
                this.blob = blobManager.saveBlob(code, fileBean.getInputStream(), fileBean.getFileName(), fileBean.getContentType(), null);
            } else {
                logger.debug("An update of a blob was requested, but nothing was uploaded. The previous value will be kept.");
                String code = req.getParameter(this.codeInputName);
                this.safeLoadBlob(code);
            }
        }
        catch (Throwable e) {
            logger.warn("Cannot save upload", e);
            throw new Error("Cannot save upload", e);
        }
        finally {
            if (fileBean != null) {
                try {
                    fileBean.delete();
                }
                catch (IOException e) {
                    logger.warn("Could not delete file bean", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean validate() {
        if (this.mode.isView(this.insertable, this.updatable) || this.mode.isBulk() && !this.bulkChecked) {
            return true;
        }
        boolean result = true;
        if (this.required && this.blob == null) {
            this.errors.add(this.getText("elements.error.field.required", new Object[0]));
            result = false;
        }
        return result;
    }

    @Override
    public void readFromObject(Object obj) {
        super.readFromObject(obj);
        if (obj == null) {
            this.blob = null;
        } else {
            String code = (String)this.accessor.get(obj);
            this.safeLoadBlob(code);
        }
    }

    protected void safeLoadBlob(String code) {
        if (code == null) {
            this.blob = null;
        } else {
            BlobManager blobManager = ElementsThreadLocals.getBlobManager();
            if (blobManager == null) {
                logger.warn("No blob manager found. Cannot load blob with code '{}'.", (Object)code);
                return;
            }
            try {
                this.blob = blobManager.loadBlob(code);
            }
            catch (Throwable e) {
                this.blob = null;
                this.blobError = this.getText("elements.error.field.fileblob.cannotLoad", new Object[0]);
                logger.warn("Cannot load blob with code '{}'. Cause: {}", (Object)code, (Object)e.getMessage());
            }
        }
    }

    @Override
    public void writeToObject(Object obj) {
        if (this.blob == null) {
            this.writeToObject(obj, null);
        } else {
            this.writeToObject(obj, this.blob.getCode());
        }
    }

    @Override
    public Blob getValue() {
        return this.blob;
    }

    public void setValue(Blob blob) {
        this.blob = blob;
    }

    public String getCodeInputName() {
        return this.codeInputName;
    }

    public String getOperationInputName() {
        return this.operationInputName;
    }

    public void setOperationInputName(String operationInputName) {
        this.operationInputName = operationInputName;
    }

    public String getBlobError() {
        return this.blobError;
    }

    public void setBlobError(String blobError) {
        this.blobError = blobError;
    }
}

