/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.PropertiesEntryAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Properties;

public class PropertiesAccessor
implements ClassAccessor {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected final PropertiesEntryAccessor[] accessors;

    public PropertiesAccessor(Properties properties) {
        this.accessors = new PropertiesEntryAccessor[properties.size()];
        int i = 0;
        for (Object current : properties.keySet()) {
            String name = (String)current;
            this.accessors[i] = new PropertiesEntryAccessor(name);
            ++i;
        }
        Arrays.sort(this.accessors, new Comparator<PropertiesEntryAccessor>(){

            @Override
            public int compare(PropertiesEntryAccessor o1, PropertiesEntryAccessor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertiesEntryAccessor current : this.accessors) {
            if (!current.getName().equals(propertyName)) continue;
            return current;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return (PropertyAccessor[])this.accessors.clone();
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return new PropertyAccessor[0];
    }

    @Override
    public Object newInstance() {
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return false;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return new Annotation[0];
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return new Annotation[0];
    }
}

