/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.annotations;

import com.manydesigns.elements.ElementsProperties;
import com.manydesigns.elements.util.InstanceBuilder;
import com.manydesigns.elements.util.ReflectionUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsManager {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    protected static final Configuration elementsConfiguration;
    protected static final AnnotationsManager manager;
    public static final Logger logger;
    protected final Map<Class, Class> annotationClassMap = new HashMap<Class, Class>();

    public static AnnotationsManager getManager() {
        return manager;
    }

    public AnnotationsManager() {
        Properties mappings = elementsConfiguration.getProperties("annotations.implementation.list");
        if (mappings == null) {
            logger.debug("Empty list");
            return;
        }
        for (Map.Entry<Object, Object> mapping : mappings.entrySet()) {
            String annotationName = (String)mapping.getKey();
            String annotationImplName = (String)mapping.getValue();
            this.addAnnotationMapping(annotationName, annotationImplName);
        }
    }

    public void addAnnotationMapping(String annotationName, String annotationImplName) {
        logger.debug("Mapping annotation {} to implemetation {}", (Object)annotationName, (Object)annotationImplName);
        Class annotationClass = ReflectionUtil.loadClass(annotationName);
        if (annotationClass == null) {
            logger.warn("Failed to load annotation class: {}", (Object)annotationName);
            return;
        }
        if (!annotationClass.isAnnotation()) {
            logger.warn("Not an annotation: {}", (Object)annotationName);
            return;
        }
        Class annotationImplClass = ReflectionUtil.loadClass(annotationImplName);
        if (annotationImplClass == null) {
            logger.warn("Failed to load annotation implementation class: {}", (Object)annotationImplName);
            return;
        }
        if (!Arrays.asList(annotationImplClass.getInterfaces()).contains(annotationClass)) {
            logger.warn("Class {} not an implementation of {}", (Object)annotationImplName, (Object)annotationName);
            return;
        }
        this.annotationClassMap.put(annotationClass, annotationImplClass);
        logger.debug("Mapped annotation {} to implementation {}", (Object)annotationName, (Object)annotationImplName);
    }

    public Set<Class> getManagedAnnotationClasses() {
        return this.annotationClassMap.keySet();
    }

    public Class getAnnotationImplementationClass(Class annotationClass) {
        return this.annotationClassMap.get(annotationClass);
    }

    static {
        logger = LoggerFactory.getLogger(AnnotationsManager.class);
        elementsConfiguration = ElementsProperties.getConfiguration();
        String managerClassName = elementsConfiguration.getString("annotations.manager");
        InstanceBuilder<AnnotationsManager> builder = new InstanceBuilder<AnnotationsManager>(AnnotationsManager.class, AnnotationsManager.class, logger);
        manager = builder.createInstance(managerClassName);
    }
}

