/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.ognl;

import com.manydesigns.elements.ElementsThreadLocals;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OgnlUtils {
    public static final String copyright = "Copyright (c) 2005-2015, ManyDesigns srl";
    public static final Logger logger = LoggerFactory.getLogger(OgnlUtils.class);

    public static Object getValueQuietly(String expression, Map ognlContext, Object root) {
        Object parsedOgnlExpression = OgnlUtils.parseExpressionQuietly(expression);
        return OgnlUtils.getValueQuietly(parsedOgnlExpression, ognlContext, root);
    }

    public static Object parseExpressionQuietly(String expression) {
        Object result;
        if (expression == null) {
            logger.warn("Null expression");
            return null;
        }
        try {
            result = Ognl.parseExpression((String)expression);
        }
        catch (OgnlException e) {
            result = null;
            logger.warn("Error during parsing of ognl expression: " + expression, (Throwable)e);
        }
        return result;
    }

    public static Object getValueQuietly(Object parsedExpression, Map ognlContext, Object root) {
        Object result;
        if (parsedExpression == null) {
            logger.warn("Null parsed expression");
            return null;
        }
        try {
            result = ognlContext == null ? Ognl.getValue((Object)parsedExpression, (Object)root) : Ognl.getValue((Object)parsedExpression, (Map)ognlContext, (Object)root);
        }
        catch (OgnlException e) {
            result = null;
            logger.debug("Error during evaluation of ognl expression: " + parsedExpression.toString(), (Throwable)e);
        }
        return result;
    }

    public static String convertValueToString(Object value) {
        return (String)OgnlUtils.convertValue(value, String.class);
    }

    public static Object convertValue(Object value, Class toType) {
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        TypeConverter typeConverter = ognlContext.getTypeConverter();
        return typeConverter.convertValue((Map)ognlContext, null, null, null, value, toType);
    }

    public static Object convertValueQuietly(Object value, Class toType) {
        try {
            return OgnlUtils.convertValue(value, toType);
        }
        catch (Throwable e) {
            logger.debug("Error during conversion of value: " + value, e);
            return null;
        }
    }
}

