/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.text;

import com.manydesigns.elements.ElementsThreadLocals;
import com.manydesigns.elements.ognl.OgnlUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ognl.OgnlContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOgnlFormat {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final Pattern pattern = Pattern.compile("%\\{[^\\}]*\\}");
    protected final String formatString;
    protected final String[] ognlExpressions;
    protected final Object[] parsedOgnlExpressions;
    public static final Logger logger = LoggerFactory.getLogger(AbstractOgnlFormat.class);

    protected AbstractOgnlFormat(String ognlFormat) {
        ArrayList<String> ognlExpressionList = new ArrayList<String>();
        ArrayList<Object> parsedOgnlExpressionList = new ArrayList<Object>();
        Matcher m = pattern.matcher(ognlFormat);
        int previousEnd = 0;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        while (m.find()) {
            int start = m.start();
            String text = ognlFormat.substring(previousEnd, start);
            String escapedText = this.escapeText(text);
            sb.append(escapedText);
            String group = m.group();
            String ognlExpression = group.substring(2, group.length() - 1);
            this.replaceOgnlExpression(sb, index, ognlExpression);
            int end = m.end();
            Object parsedOgnlExpression = OgnlUtils.parseExpressionQuietly(ognlExpression);
            ognlExpressionList.add(ognlExpression);
            parsedOgnlExpressionList.add(parsedOgnlExpression);
            previousEnd = end;
            ++index;
        }
        String text = ognlFormat.substring(previousEnd, ognlFormat.length());
        String escapedText = this.escapeText(text);
        sb.append(escapedText);
        this.formatString = sb.toString();
        this.ognlExpressions = new String[ognlExpressionList.size()];
        ognlExpressionList.toArray(this.ognlExpressions);
        this.parsedOgnlExpressions = new Object[parsedOgnlExpressionList.size()];
        parsedOgnlExpressionList.toArray(this.parsedOgnlExpressions);
    }

    protected String escapeText(String text) {
        return text;
    }

    protected abstract void replaceOgnlExpression(StringBuilder var1, int var2, String var3);

    public Object[] evaluateOgnlExpressions(Object root) {
        OgnlContext ognlContext = ElementsThreadLocals.getOgnlContext();
        Object[] result = new Object[this.parsedOgnlExpressions.length];
        for (int i = 0; i < result.length; ++i) {
            this.evaluateOneOgnlExpression(root, (Map)ognlContext, result, i);
        }
        return result;
    }

    protected void evaluateOneOgnlExpression(Object root, Map ognlContext, Object[] result, int i) {
        Object ognlResult;
        Object parsedOgnlExpression = this.parsedOgnlExpressions[i];
        result[i] = ognlResult = OgnlUtils.getValueQuietly(parsedOgnlExpression, ognlContext, root);
    }

    public String getFormatString() {
        return this.formatString;
    }

    public String[] getOgnlExpressions() {
        return this.ognlExpressions;
    }

    public Object[] getParsedOgnlExpressions() {
        return this.parsedOgnlExpressions;
    }
}

