/*
 * Decompiled with CFR 0.152.
 */
package com.manydesigns.elements.reflection;

import com.manydesigns.elements.annotations.Key;
import com.manydesigns.elements.reflection.ClassAccessor;
import com.manydesigns.elements.reflection.JavaFieldAccessor;
import com.manydesigns.elements.reflection.JavaPropertyAccessor;
import com.manydesigns.elements.reflection.PropertyAccessor;
import com.manydesigns.elements.util.ReflectionUtil;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaClassAccessor
implements ClassAccessor {
    public static final String copyright = "Copyright (c) 2005-2014, ManyDesigns srl";
    public static final String[] PROPERTY_NAME_BLACKLIST = new String[]{"class"};
    protected final Class javaClass;
    protected final PropertyAccessor[] propertyAccessors;
    protected final PropertyAccessor[] keyPropertyAccessors;
    protected static final Map<Class, JavaClassAccessor> classAccessorCache;
    public static final Logger logger;

    public static JavaClassAccessor getClassAccessor(Class javaClass) {
        JavaClassAccessor cachedResult = classAccessorCache.get(javaClass);
        if (cachedResult == null) {
            logger.debug("Cache miss for: {}", (Object)javaClass);
            cachedResult = new JavaClassAccessor(javaClass);
            logger.debug("Caching key: {} - Value: {}", (Object)javaClass, (Object)cachedResult);
            classAccessorCache.put(javaClass, cachedResult);
        } else {
            logger.debug("Cache hit for: {} - Value: {}", (Object)javaClass, (Object)cachedResult);
        }
        return cachedResult;
    }

    protected JavaClassAccessor(Class javaClass) {
        this.javaClass = javaClass;
        List<PropertyAccessor> accessorList = this.setupPropertyAccessors();
        this.propertyAccessors = new PropertyAccessor[accessorList.size()];
        accessorList.toArray(this.propertyAccessors);
        List<PropertyAccessor> keyAccessors = this.setupKeyPropertyAccessors();
        this.keyPropertyAccessors = new PropertyAccessor[keyAccessors.size()];
        keyAccessors.toArray(this.keyPropertyAccessors);
    }

    protected List<PropertyAccessor> setupPropertyAccessors() {
        ArrayList<PropertyAccessor> accessorList = new ArrayList<PropertyAccessor>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(this.javaClass);
            for (PropertyDescriptor current : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                JavaPropertyAccessor accessor = new JavaPropertyAccessor(current);
                if (!this.isValidProperty(accessor)) continue;
                accessorList.add(accessor);
            }
        }
        catch (IntrospectionException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        for (Field field : this.javaClass.getFields()) {
            JavaFieldAccessor accessor;
            if (this.isPropertyPresent(accessorList, field.getName()) || !this.isValidProperty(accessor = new JavaFieldAccessor(field))) continue;
            accessorList.add(accessor);
        }
        return accessorList;
    }

    protected boolean isValidProperty(PropertyAccessor propertyAccessor) {
        if (Modifier.isStatic(propertyAccessor.getModifiers())) {
            return false;
        }
        return !ArrayUtils.contains((Object[])PROPERTY_NAME_BLACKLIST, (Object)propertyAccessor.getName());
    }

    protected List<PropertyAccessor> setupKeyPropertyAccessors() {
        HashMap<String, ArrayList<PropertyAccessor>> keys = new HashMap<String, ArrayList<PropertyAccessor>>();
        for (PropertyAccessor propertyAccessor : this.propertyAccessors) {
            Key key = propertyAccessor.getAnnotation(Key.class);
            if (key == null) continue;
            ArrayList<PropertyAccessor> keyProperties = (ArrayList<PropertyAccessor>)keys.get(key.name());
            if (keyProperties == null) {
                keyProperties = new ArrayList<PropertyAccessor>();
                keys.put(key.name(), keyProperties);
            }
            keyProperties.add(propertyAccessor);
        }
        if (keys.isEmpty()) {
            logger.debug("No primary key configured for {}", (Object)this.javaClass);
            return Collections.emptyList();
        }
        Key key = this.getAnnotation(Key.class);
        String primaryKeyName = key != null ? key.name() : "default";
        List keyAccessors = (List)keys.get(primaryKeyName);
        if (keyAccessors == null) {
            keyAccessors = (List)keys.get("default");
        }
        if (keyAccessors == null) {
            logger.debug("Primary key \"" + primaryKeyName + "\" not found in " + this.javaClass + "; using the first available key.");
            keyAccessors = (List)keys.values().iterator().next();
        }
        Collections.sort(keyAccessors, new Comparator<PropertyAccessor>(){

            @Override
            public int compare(PropertyAccessor o1, PropertyAccessor o2) {
                Integer ord1 = o1.getAnnotation(Key.class).order();
                Integer ord2 = o2.getAnnotation(Key.class).order();
                return ord1.compareTo(ord2);
            }
        });
        return keyAccessors;
    }

    private boolean isPropertyPresent(List<PropertyAccessor> accessorList, String name) {
        for (PropertyAccessor current : accessorList) {
            if (!current.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.javaClass.getName();
    }

    @Override
    public PropertyAccessor getProperty(String propertyName) throws NoSuchFieldException {
        for (PropertyAccessor current : this.propertyAccessors) {
            if (!current.getName().equals(propertyName)) continue;
            return current;
        }
        throw new NoSuchFieldException(propertyName);
    }

    @Override
    public PropertyAccessor[] getProperties() {
        return (PropertyAccessor[])this.propertyAccessors.clone();
    }

    @Override
    public PropertyAccessor[] getKeyProperties() {
        return (PropertyAccessor[])this.keyPropertyAccessors.clone();
    }

    @Override
    public Object newInstance() {
        return ReflectionUtil.newInstance(this.javaClass);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.javaClass.isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.javaClass.getAnnotation(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.javaClass.getAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.javaClass.getDeclaredAnnotations();
    }

    public Class getJavaClass() {
        return this.javaClass;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("javaClass", (Object)this.javaClass).toString();
    }

    static {
        logger = LoggerFactory.getLogger(JavaClassAccessor.class);
        classAccessorCache = new HashMap<Class, JavaClassAccessor>();
    }
}

