/*
 * Decompiled with CFR 0.152.
 */
package com.mailosaur;

import com.google.api.client.http.BasicAuthentication;
import com.google.api.client.http.EmptyContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.gson.GsonFactory;
import com.google.api.client.util.ObjectParser;
import com.mailosaur.Analysis;
import com.mailosaur.Files;
import com.mailosaur.MailosaurException;
import com.mailosaur.Messages;
import com.mailosaur.Servers;
import com.mailosaur.models.MailosaurError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class MailosaurClient {
    final String VERSION = "6.0.0";
    final String API_KEY;
    final String BASE_URL;
    final HttpTransport HTTP_TRANSPORT = new NetHttpTransport();
    final JsonFactory JSON_FACTORY = new GsonFactory();
    final HttpRequestFactory requestFactory = this.HTTP_TRANSPORT.createRequestFactory(new HttpRequestInitializer(){

        public void initialize(HttpRequest request) {
            request.setParser((ObjectParser)new JsonObjectParser(MailosaurClient.this.JSON_FACTORY));
        }
    });
    private Analysis analysis;
    private Files files;
    private Messages messages;
    private Servers servers;

    public MailosaurClient(String apiKey) {
        this(apiKey, null);
    }

    public MailosaurClient(String apiKey, String baseUrl) {
        this.API_KEY = apiKey;
        this.BASE_URL = baseUrl != null ? baseUrl : "https://mailosaur.com/";
        this.analysis = new Analysis(this);
        this.files = new Files(this);
        this.messages = new Messages(this);
        this.servers = new Servers(this);
    }

    public Analysis analysis() {
        return this.analysis;
    }

    public Files files() {
        return this.files;
    }

    public Messages messages() {
        return this.messages;
    }

    public Servers servers() {
        return this.servers;
    }

    public HttpResponse request(String method, String url) throws MailosaurException {
        return this.request(method, url, null);
    }

    public HttpResponse request(String method, String url, HashMap<String, String> query) throws MailosaurException {
        return this.request(method, url, null, query);
    }

    public HttpResponse request(String method, String url, Object content) throws MailosaurException {
        return this.request(method, url, content, null);
    }

    public HttpResponse request(String method, String url, Object content, HashMap<String, String> query) throws MailosaurException {
        Throwable ex = null;
        HttpRequest request = null;
        HttpResponse response = null;
        for (int i = 0; i < 3; ++i) {
            try {
                request = this.buildRequest(method, url, content, query);
                response = request.execute();
                if (response.getStatusCode() != 200 && response.getStatusCode() != 204) {
                    String message = String.format("Operation returned an invalid status code '%s'", response.getStatusCode());
                    MailosaurException mailosaurException = new MailosaurException(message);
                    MailosaurError mailosaurError = (MailosaurError)response.parseAs(MailosaurError.class);
                    mailosaurException.withMailosaurError(mailosaurError);
                    throw mailosaurException;
                }
                return response;
            }
            catch (IOException ioException) {
                ex = ioException;
                continue;
            }
        }
        throw new MailosaurException(ex.getMessage());
    }

    public ByteArrayOutputStream requestFile(String method, String path) throws MailosaurException, IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.request(method, path).download((OutputStream)stream);
        return stream;
    }

    private HttpRequest buildRequest(String method, String path, Object content, Map<String, String> query) throws MailosaurException, IOException {
        HttpRequest request;
        GenericUrl url = this.buildUrl(path, query);
        switch (method) {
            case "POST": {
                request = content != null ? this.requestFactory.buildPostRequest(url, (HttpContent)new JsonHttpContent(this.JSON_FACTORY, content)) : this.requestFactory.buildPostRequest(url, (HttpContent)new EmptyContent());
                break;
            }
            case "PUT": {
                request = this.requestFactory.buildPutRequest(url, (HttpContent)new JsonHttpContent(this.JSON_FACTORY, content));
                break;
            }
            case "DELETE": {
                request = this.requestFactory.buildDeleteRequest(url);
                break;
            }
            default: {
                request = this.requestFactory.buildGetRequest(url);
            }
        }
        request.setInterceptor((HttpExecuteInterceptor)new BasicAuthentication(this.API_KEY, ""));
        HttpHeaders headers = request.getHeaders();
        headers.setUserAgent("mailosaur-java/6.0.0");
        return request;
    }

    private String buildQueryString(Map<String, String> map) throws UnsupportedEncodingException {
        HashMap<String, String> query = new HashMap<String, String>();
        if (map != null) {
            query.putAll(map);
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : query.entrySet()) {
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        return sb.toString();
    }

    private GenericUrl buildUrl(String path, Map<String, String> query) throws UnsupportedEncodingException {
        return new GenericUrl(this.BASE_URL + path + "?" + this.buildQueryString(query));
    }
}

