/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.ContextItem;
import com.machinepublishers.jbrowserdriver.Dimension;
import com.machinepublishers.jbrowserdriver.ElementId;
import com.machinepublishers.jbrowserdriver.ElementRemote;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.Point;
import com.machinepublishers.jbrowserdriver.Rectangle;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.Robot;
import com.machinepublishers.jbrowserdriver.Util;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.stage.Stage;
import netscape.javascript.JSObject;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.ElementNotVisibleException;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.FindsByClassName;
import org.openqa.selenium.internal.FindsByCssSelector;
import org.openqa.selenium.internal.FindsById;
import org.openqa.selenium.internal.FindsByLinkText;
import org.openqa.selenium.internal.FindsByName;
import org.openqa.selenium.internal.FindsByTagName;
import org.openqa.selenium.internal.FindsByXPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLFormElement;
import org.w3c.dom.html.HTMLInputElement;
import org.w3c.dom.html.HTMLOptionElement;

class ElementServer
extends RemoteObject
implements ElementRemote,
WebElement,
JavascriptExecutor,
FindsById,
FindsByClassName,
FindsByLinkText,
FindsByName,
FindsByCssSelector,
FindsByTagName,
FindsByXPath {
    private static final String IS_VISIBLE;
    private static final String SCROLL_INTO_VIEW;
    private static final Pattern rgb;
    private static final Map<ElementId, ElementServer> map;
    private final JSObject node;
    private final ContextItem contextItem;
    private final AtomicLong frameId = new AtomicLong();

    ElementServer(JSObject node, ContextItem contextItem) throws RemoteException {
        AppThread.exec(contextItem.statusCode, () -> {
            ElementServer.validate(node, contextItem);
            node.getMember("");
            return null;
        });
        this.node = node;
        this.contextItem = contextItem;
    }

    JSObject node() {
        return this.node;
    }

    void setFrameId(long frameId) {
        this.frameId.set(frameId);
    }

    long frameId() {
        return this.frameId.get();
    }

    static ElementServer create(ContextItem contextItem) {
        JSObject doc = AppThread.exec(contextItem.statusCode, contextItem::selectedFrameDoc);
        try {
            return new ElementServer(doc, contextItem);
        }
        catch (RemoteException e) {
            Util.handleException(e);
            return null;
        }
    }

    @Override
    public void activate() {
        this.contextItem.selectFrame(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scriptParam(ElementId id) {
        Map<ElementId, ElementServer> map = ElementServer.map;
        synchronized (map) {
            ElementServer.map.put(id, this);
        }
    }

    private static void validate(JSObject node, ContextItem contextItem) {
        JSObject doc;
        if (node == null) {
            throw new NoSuchElementException("Element not found or does not exist.");
        }
        JSObject jSObject = doc = node instanceof Document ? node : (JSObject)((Object)((Node)((Object)node)).getOwnerDocument());
        if (!contextItem.containsFrame(doc)) {
            throw new StaleElementReferenceException("The page containing the element no longer exists.");
        }
        if (!((Boolean)doc.call("contains", node)).booleanValue()) {
            throw new StaleElementReferenceException("The element no longer exists within the page.");
        }
    }

    private void validate(boolean mustBeVisible) {
        ElementServer.validate(this.node, this.contextItem);
        if (mustBeVisible && !this.isDisplayed()) {
            throw new ElementNotVisibleException("Element is not visible.");
        }
    }

    @Override
    public void click() {
        AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            this.node.eval(SCROLL_INTO_VIEW);
            if (this.contextItem.context.get().keyboard.get().isShiftPressed()) {
                this.node.eval("this.origOnclick = this.onclick;" + "this.onclick=function(event){" + "  this.target='_blank';" + "  if(event){" + "    if(event.stopPropagation){" + "      event.stopPropagation();" + "    }" + "  }" + "  if(this.origOnclick){" + "    this.origOnclick(event? event: null);" + "  }" + "  this.onclick = this.origOnclick;" + "};");
            }
            return null;
        });
        if (this.node instanceof HTMLOptionElement) {
            AppThread.exec(this.contextItem.statusCode, () -> {
                this.validate(false);
                try {
                    new ElementServer((JSObject)((Object)((HTMLOptionElement)((Object)this.node)).getParentNode()), this.contextItem).click();
                }
                catch (RemoteException e) {
                    Util.handleException(e);
                }
                int index = ((HTMLOptionElement)((Object)this.node)).getIndex();
                for (int i = 0; i <= index; ++i) {
                    this.contextItem.context.get().robot.get().keysType(new CharSequence[]{Keys.DOWN});
                }
                this.contextItem.context.get().robot.get().keysType(new CharSequence[]{Keys.SPACE});
                return null;
            });
        } else {
            AppThread.exec(this.contextItem.statusCode, () -> {
                this.validate(true);
                JSObject obj = (JSObject)this.node.call("getBoundingClientRect", new Object[0]);
                double top = Double.parseDouble(obj.getMember("top").toString());
                double left = Double.parseDouble(obj.getMember("left").toString());
                double bottom = Double.parseDouble(obj.getMember("bottom").toString());
                double right = Double.parseDouble(obj.getMember("right").toString());
                double clickX = (left + right) / 2.0;
                double clickY = (top + bottom) / 2.0;
                ElementServer doc = ElementServer.create(this.contextItem);
                if (!this.node.equals(doc.node.eval("(function(){return document.elementFromPoint(" + clickX + "," + clickY + ");})();"))) {
                    Stage stage = this.contextItem.stage.get();
                    int minX = Math.max(0, (int)Math.floor(left));
                    int maxX = Math.min((int)Math.ceil(stage.getScene().getWidth()), (int)Math.ceil(right));
                    int minY = Math.max(0, (int)Math.floor(top));
                    int maxY = Math.min((int)Math.ceil(stage.getScene().getHeight()), (int)Math.ceil(bottom));
                    int incX = (int)Math.max(1.0, 0.05 * (double)(maxX - minX));
                    int incY = (int)Math.max(1.0, 0.05 * (double)(maxY - minY));
                    for (int x = minX; x <= maxX; x += incX) {
                        boolean found = false;
                        for (int y = minY; y <= maxY; y += incY) {
                            if (!this.node.equals(doc.node.eval("(function(){return document.elementFromPoint(" + x + "," + y + ");})();"))) continue;
                            clickX = x;
                            clickY = y;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                }
                org.openqa.selenium.Point frameLocation = this.contextItem.selectedFrameLocation();
                this.contextItem.context.get().robot.get().mouseMove(clickX + (double)frameLocation.getX(), clickY + (double)frameLocation.getY());
                this.contextItem.context.get().robot.get().mouseClick(Robot.MouseButton.LEFT);
                return null;
            });
        }
    }

    @Override
    public void submit() {
        AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            this.contextItem.httpListener.get().resetStatusCode();
            if (this.node instanceof HTMLInputElement) {
                ((HTMLInputElement)((Object)this.node)).getForm().submit();
            } else if (this.node instanceof HTMLFormElement) {
                ((HTMLFormElement)((Object)this.node)).submit();
            }
            return null;
        });
    }

    @Override
    public void sendKeys(CharSequence ... keys) {
        boolean fileChooser;
        AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(true);
            this.node.eval(SCROLL_INTO_VIEW);
            this.node.call("focus", new Object[0]);
            return null;
        });
        boolean bl = fileChooser = this.node instanceof HTMLInputElement && "file".equalsIgnoreCase(this.getAttribute("type"));
        if (fileChooser) {
            this.click();
        }
        this.contextItem.context.get().robot.get().keysType(keys);
        if (fileChooser) {
            this.contextItem.context.get().robot.get().typeEnter();
        }
    }

    @Override
    public void clear() {
        AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            this.contextItem.httpListener.get().resetStatusCode();
            this.node.eval(SCROLL_INTO_VIEW);
            this.node.call("focus", new Object[0]);
            this.node.eval("this.value='';");
            return null;
        });
    }

    @Override
    public String getAttribute(String attrName) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            String str;
            this.validate(false);
            Object obj = this.node.getMember(attrName);
            if (obj != null && !StringUtils.isEmpty((String)(str = obj.toString())) && !"undefined".equals(str)) {
                return str;
            }
            obj = this.executeScript("return this.getAttribute('" + attrName + "');", new Object[0]);
            if (obj != null && !StringUtils.isEmpty((String)(str = obj.toString()))) {
                return str;
            }
            return null;
        });
    }

    @Override
    public String getCssValue(String name) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            return ElementServer.cleanUpCssVal((String)this.node.eval("var me = this;" + "(function(){" + "  return window.getComputedStyle(me).getPropertyValue('" + name + "');" + "})();"));
        });
    }

    private static String cleanUpCssVal(String rgbStr) {
        Matcher matcher;
        if (rgbStr != null && (matcher = rgb.matcher(rgbStr)).matches()) {
            return "rgba(" + matcher.group(1) + ", " + matcher.group(2) + ", " + matcher.group(3) + ", 1)";
        }
        return rgbStr == null ? "" : rgbStr;
    }

    @Override
    public Point remoteGetLocation() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(true);
            JSObject obj = (JSObject)this.node.call("getBoundingClientRect", new Object[0]);
            int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
            int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
            return new Point(x + 1, y + 1);
        });
    }

    public org.openqa.selenium.Point getLocation() {
        return this.remoteGetLocation().toSelenium();
    }

    @Override
    public Dimension remoteGetSize() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(true);
            JSObject obj = (JSObject)this.node.call("getBoundingClientRect", new Object[0]);
            int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
            int y2 = (int)Math.rint(Double.parseDouble(obj.getMember("bottom").toString()));
            int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
            int x2 = (int)Math.rint(Double.parseDouble(obj.getMember("right").toString()));
            return new Dimension(x2 - x, y2 - y);
        });
    }

    public org.openqa.selenium.Dimension getSize() {
        return this.remoteGetSize().toSelenium();
    }

    @Override
    public Rectangle remoteGetRect() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(true);
            JSObject obj = (JSObject)this.node.call("getBoundingClientRect", new Object[0]);
            int y = (int)Math.rint(Double.parseDouble(obj.getMember("top").toString()));
            int y2 = (int)Math.rint(Double.parseDouble(obj.getMember("bottom").toString()));
            int x = (int)Math.rint(Double.parseDouble(obj.getMember("left").toString()));
            int x2 = (int)Math.rint(Double.parseDouble(obj.getMember("right").toString()));
            return new Rectangle(x + 1, y + 1, y2 - y, x2 - x);
        });
    }

    public org.openqa.selenium.Rectangle getRect() {
        return this.remoteGetRect().toSelenium();
    }

    @Override
    public String getTagName() {
        return this.getAttribute("tagName").toLowerCase();
    }

    @Override
    public String getText() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            if (((Boolean)this.node.eval(IS_VISIBLE)).booleanValue()) {
                String textAttribute = "TEXTAREA".equals(this.node.getMember("tagName")) ? "textContent" : "innerText";
                Object text = this.node.getMember(textAttribute);
                return text instanceof String ? ((String)text).trim() : "";
            }
            return "";
        });
    }

    @Override
    public boolean isDisplayed() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            return (Boolean)this.node.eval(IS_VISIBLE);
        });
    }

    @Override
    public boolean isEnabled() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            String val = this.node.getMember("disabled").toString();
            return val == null || "undefined".equals(val) || val.isEmpty() || "false".equals(val);
        });
    }

    @Override
    public boolean isSelected() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            String selected = this.node.getMember("selected").toString();
            String checked = this.node.getMember("checked").toString();
            return selected != null && !"undefined".equals(selected) && !"false".equals(selected) && !selected.isEmpty() || checked != null && !"undefined".equals(checked) && !"false".equals(checked) && !checked.isEmpty();
        });
    }

    @Override
    public ElementServer findElement(By by) {
        return (ElementServer)by.findElement((SearchContext)this);
    }

    public List findElements(By by) {
        return by.findElements((SearchContext)this);
    }

    @Override
    public ElementServer findElementByXPath(String expr) {
        List list = this.findElementsByXPath(expr);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByXPath(String expr) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            return ElementServer.asList(this.executeScript("var iter = " + "  document.evaluate(arguments[0], arguments[1], null, XPathResult.ORDERED_NODE_ITERATOR_TYPE);" + "var items = [];" + "var cur = null;" + "while(cur = iter.iterateNext()){" + "  items.push(cur);" + "}" + "return items;", expr, this.node));
        });
    }

    @Override
    public ElementServer findElementByTagName(String tagName) {
        List list = this.byTagName(tagName);
        return list == null || list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByTagName(String tagName) {
        return this.byTagName(tagName);
    }

    private List byTagName(String tagName) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            if (this.node != null) {
                return ElementServer.asList(this.parseScriptResult(this.node.call("getElementsByTagName", tagName)));
            }
            return new ArrayList();
        });
    }

    @Override
    public ElementServer findElementByCssSelector(String expr) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            JSObject result = (JSObject)this.node.call("querySelector", expr);
            if (result == null) {
                return null;
            }
            try {
                return new ElementServer(result, this.contextItem);
            }
            catch (RemoteException e) {
                Util.handleException(e);
                return null;
            }
        });
    }

    public List findElementsByCssSelector(String expr) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            Object cur;
            this.validate(false);
            ArrayList<ElementServer> elements = new ArrayList<ElementServer>();
            JSObject result = (JSObject)this.node.call("querySelectorAll", expr);
            int i = 0;
            while ((cur = result.getSlot(i)) instanceof Node) {
                try {
                    elements.add(new ElementServer((JSObject)cur, this.contextItem));
                }
                catch (RemoteException e) {
                    Util.handleException(e);
                }
                ++i;
            }
            return elements;
        });
    }

    @Override
    public ElementServer findElementByName(String name) {
        return this.findElementByCssSelector("*[name='" + name + "']");
    }

    public List findElementsByName(String name) {
        return this.findElementsByCssSelector("*[name='" + name + "']");
    }

    @Override
    public ElementServer findElementByLinkText(String text) {
        List list = this.byLinkText(text, false, false);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    @Override
    public ElementServer findElementByPartialLinkText(String text) {
        List list = this.byLinkText(text, false, true);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByLinkText(String text) {
        return this.byLinkText(text, true, false);
    }

    public List findElementsByPartialLinkText(String text) {
        return this.byLinkText(text, true, true);
    }

    private List byLinkText(String text, boolean multiple, boolean partial) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            ArrayList<ElementServer> elements = new ArrayList<ElementServer>();
            List nodes = this.findElementsByTagName("a");
            for (ElementServer cur : nodes) {
                String curText = cur.getText();
                if (curText == null || (!partial || !curText.contains(text)) && (partial || !curText.equals(text))) continue;
                elements.add(cur);
                if (multiple) continue;
                break;
            }
            return elements;
        });
    }

    @Override
    public ElementServer findElementByClassName(String cssClass) {
        List list = this.byCssClass(cssClass);
        return list.isEmpty() ? null : (ElementServer)list.get(0);
    }

    public List findElementsByClassName(String cssClass) {
        return this.byCssClass(cssClass);
    }

    private List byCssClass(String cssClass) {
        return ElementServer.asList(this.executeScript("return this.getElementsByClassName('" + cssClass + "');", new Object[0]));
    }

    @Override
    public ElementServer findElementById(String id) {
        return this.findElementByCssSelector("*[id='" + id + "']");
    }

    public List findElementsById(String id) {
        return this.findElementsByCssSelector("*[id='" + id + "']");
    }

    @Override
    public Object executeAsyncScript(String script, Object ... args) {
        JavascriptNames jsNames = new JavascriptNames();
        this.script(true, script, args, jsNames);
        long timeoutAt = this.contextItem.context.get().timeouts.get().getScriptTimeoutMS();
        timeoutAt = timeoutAt > 0L ? (timeoutAt += System.currentTimeMillis()) : Long.MAX_VALUE;
        int sleep = 1;
        int sleepBackoff = 2;
        int sleepMax = 257;
        try {
            do {
                sleep = sleep < 257 ? sleep * 2 : sleep;
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Object result = AppThread.exec(this.contextItem.statusCode, () -> {
                    this.validate(false);
                    return this.node.eval("(function(){return this." + jsNames.callbackVal + ";})();");
                });
                if (result instanceof String && "undefined".equals(result.toString())) continue;
                Object parsed = this.parseScriptResult(result);
                if (parsed instanceof List) {
                    if (((List)parsed).size() == 0) {
                        Object var11_11 = null;
                        return var11_11;
                    }
                    if (((List)parsed).size() == 1) {
                        Object e = ((List)parsed).get(0);
                        return e;
                    }
                }
                Object object = parsed;
                return object;
            } while (System.currentTimeMillis() <= timeoutAt);
            throw new TimeoutException("Timeout of " + this.contextItem.context.get().timeouts.get().getScriptTimeoutMS() + "ms reached for waiting async script to complete.");
        }
        finally {
            AppThread.exec(this.contextItem.statusCode, () -> {
                this.validate(false);
                this.node.eval("delete " + jsNames.callbackVal + ";");
                return null;
            });
        }
    }

    @Override
    public Object executeScript(String script, Object ... args) {
        return this.script(false, script, args, new JavascriptNames());
    }

    private static List<ElementServer> asList(Object objToCast) {
        try {
            return (List)objToCast;
        }
        catch (ClassCastException e) {
            return new ArrayList<ElementServer>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object script(boolean callback, String script, Object[] args, JavascriptNames jsNames) {
        for (int i = 0; args != null && i < args.length; ++i) {
            if (!(args[i] instanceof ElementId)) continue;
            Map<ElementId, ElementServer> map = ElementServer.map;
            synchronized (map) {
                args[i] = ElementServer.map.remove((Object)args[i]).node;
                continue;
            }
        }
        return this.parseScriptResult(AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            ArrayList<Object> argList = new ArrayList<Object>();
            if (args != null) {
                argList.addAll(Arrays.asList(args));
            }
            try {
                if (callback) {
                    argList.add(null);
                    this.node.eval("(function(){" + "this." + jsNames.callback + " = function(){" + jsNames.callbackVal + " = arguments && arguments.length > 0? arguments[0] : null;" + "}" + "}).apply(this);" + "this." + jsNames.exec + " = function(){" + "arguments[arguments.length-1] = this." + jsNames.callback + ";" + "return (function(){" + script + "}).apply(this, arguments);" + "};");
                } else {
                    this.node.eval("this." + jsNames.exec + " = function(){" + "return (function(){" + script + "}).apply(this, arguments);" + "};");
                }
                Object object = this.node.call(jsNames.exec, argList.toArray(new Object[0]));
                return object;
            }
            catch (Throwable t) {
                Throwable throwable = t;
                return throwable;
            }
            finally {
                this.node.eval("delete this." + jsNames.exec + ";");
                if (callback) {
                    this.node.eval("delete this." + jsNames.callback + ";");
                }
            }
        }));
    }

    private Object parseScriptResult(Object obj) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            AppThread.handleExecutionException(obj);
            if (obj == null || obj instanceof String && "undefined".equals(obj.toString())) {
                return null;
            }
            if (obj instanceof Node) {
                try {
                    return new ElementServer((JSObject)obj, this.contextItem);
                }
                catch (RemoteException e) {
                    Util.handleException(e);
                    return null;
                }
            }
            if (obj instanceof JSObject) {
                Object cur;
                ArrayList<Object> list = new ArrayList<Object>();
                boolean isList = false;
                int i = 0;
                while (!((cur = ((JSObject)obj).getSlot(i)) instanceof String) || !"undefined".equals(cur.toString())) {
                    isList = true;
                    list.add(this.parseScriptResult(cur));
                    ++i;
                }
                if (isList) {
                    return list;
                }
                if ("function".equals(this.executeScript("return typeof arguments[0];", obj))) {
                    return obj.toString();
                }
                if (Boolean.TRUE.equals(this.executeScript("return Array.isArray(arguments[0]);", obj))) {
                    return new ArrayList();
                }
                List mapAsList = (List)this.executeScript("var list = [];" + "for(var propertyName in arguments[0]){" + "list.push(propertyName);" + "var val = arguments[0][propertyName];" + "list.push(val === undefined? null : val);" + "}" + "return list.length > 0? list : undefined;", obj);
                LinkedHashMap map = new LinkedHashMap();
                for (int i2 = 0; mapAsList != null && i2 < mapAsList.size(); i2 += 2) {
                    map.put(mapAsList.get(i2).toString(), mapAsList.get(i2 + 1));
                }
                return map;
            }
            if (obj instanceof Boolean || obj instanceof Long || obj instanceof Double) {
                return obj;
            }
            if (obj instanceof Integer) {
                return new Long(((Integer)obj).intValue());
            }
            if (obj instanceof Float) {
                return new Double(((Float)obj).floatValue());
            }
            return obj.toString();
        });
    }

    @Override
    public Point locate() {
        AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            this.node.eval(SCROLL_INTO_VIEW);
            return null;
        });
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(true);
            JSObject obj = (JSObject)this.node.call("getBoundingClientRect", new Object[0]);
            double y = Double.parseDouble(obj.getMember("top").toString());
            double x = Double.parseDouble(obj.getMember("left").toString());
            y = y < 0.0 ? 0.0 : y;
            x = x < 0.0 ? 0.0 : x;
            org.openqa.selenium.Point frameLocation = this.contextItem.selectedFrameLocation();
            return new Point((int)Math.rint(x) + 1 + frameLocation.getX(), (int)Math.rint(y) + 1 + frameLocation.getY());
        });
    }

    public <X> X getScreenshotAs(OutputType<X> arg0) throws WebDriverException {
        LogsServer.instance().warn("Screenshot not supported on jBrowserDriver WebElements");
        return null;
    }

    @Override
    public byte[] getScreenshot() throws WebDriverException {
        LogsServer.instance().warn("Screenshot not supported on jBrowserDriver WebElements");
        return null;
    }

    @Override
    public int remoteHashCode() {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            this.validate(false);
            return this.node.hashCode();
        });
    }

    @Override
    public boolean remoteEquals(ElementId id) {
        return AppThread.exec(this.contextItem.statusCode, () -> {
            ElementServer other;
            this.validate(false);
            Map<ElementId, ElementServer> map = map;
            synchronized (map) {
                other = map.remove(id);
            }
            other.validate(false);
            return this.node.equals(other.node);
        });
    }

    static {
        StringBuilder builder = new StringBuilder();
        builder.append("var me = this;");
        builder.append("(function(){");
        builder.append("var findEffectiveStyle = function(element) {");
        builder.append("  if (element.style == undefined) {");
        builder.append("    return undefined;");
        builder.append("  }");
        builder.append("  if (window.getComputedStyle) {");
        builder.append("    return window.getComputedStyle(element, null);");
        builder.append("  }");
        builder.append("  if (element.currentStyle) {");
        builder.append("    return element.currentStyle;");
        builder.append("  }");
        builder.append("  if (window.document.defaultView && window.document.defaultView.getComputedStyle) {");
        builder.append("    return window.document.defaultView.getComputedStyle(element, null);");
        builder.append("  }");
        builder.append("  return undefined;");
        builder.append("};");
        builder.append("var findEffectiveStyleProperty = function(element, property) {");
        builder.append("  var effectiveStyle = findEffectiveStyle(element);");
        builder.append("  var propertyValue = effectiveStyle[property];");
        builder.append("  if (propertyValue == 'inherit' && element.parentNode.style) {");
        builder.append("    return findEffectiveStyleProperty(element.parentNode, property);");
        builder.append("  }");
        builder.append("  return propertyValue;");
        builder.append("};");
        builder.append("var isDisplayed = function(element) {");
        builder.append("  var display = findEffectiveStyleProperty(element, \"display\");");
        builder.append("  if (display == \"none\") return false;");
        builder.append("  if (element.parentNode.style) {");
        builder.append("    return isDisplayed(element.parentNode);");
        builder.append("  }");
        builder.append("  return true;");
        builder.append("};");
        builder.append("var isVisible = function(element) {");
        builder.append("  if (element.tagName) {");
        builder.append("    var tagName = new String(element.tagName).toLowerCase();");
        builder.append("    if (tagName == \"input\") {");
        builder.append("      if (element.type) {");
        builder.append("        var elementType = new String(element.type).toLowerCase();");
        builder.append("        if (elementType == \"hidden\") {");
        builder.append("          return false;");
        builder.append("        }");
        builder.append("      }");
        builder.append("    }");
        builder.append("  }");
        builder.append("  var visibility = findEffectiveStyleProperty(element, \"visibility\");");
        builder.append("  return (visibility != \"hidden\" && isDisplayed(element));");
        builder.append("};");
        builder.append("return isVisible(me);");
        builder.append("})();");
        IS_VISIBLE = builder.toString();
        builder = new StringBuilder();
        builder.append("var me = this;");
        builder.append("(function(){");
        builder.append("  var rect = me.getBoundingClientRect();");
        builder.append("  if(rect");
        builder.append("      && (rect.top < 0");
        builder.append("      || rect.left < 0");
        builder.append("      || rect.bottom > window.innerHeight");
        builder.append("      || rect.right > window.innerWidth");
        builder.append("      || rect.bottom > document.documentElement.clientHeight");
        builder.append("      || rect.right > document.documentElement.clientWidth)) {");
        builder.append("    me.scrollIntoView();");
        builder.append("  }");
        builder.append("})();");
        SCROLL_INTO_VIEW = builder.toString();
        rgb = Pattern.compile("rgb\\(([0-9]{1,3}), ([0-9]{1,3}), ([0-9]{1,3})\\)");
        map = new HashMap<ElementId, ElementServer>();
    }

    private static class JavascriptNames {
        private final String callbackVal = Util.randomPropertyName();
        private final String callback = Util.randomPropertyName();
        private final String exec = Util.randomPropertyName();

        private JavascriptNames() {
        }
    }
}

