/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Dimension;
import com.machinepublishers.jbrowserdriver.Point;
import com.machinepublishers.jbrowserdriver.RemoteObject;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.WindowRemote;
import java.rmi.RemoteException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.stage.Stage;
import org.openqa.selenium.WebDriver;

class WindowServer
extends RemoteObject
implements WindowRemote,
WebDriver.Window {
    private final AtomicReference<Stage> stage;
    private final AtomicInteger statusCode;

    WindowServer(AtomicReference<Stage> stage, AtomicInteger statusCode) throws RemoteException {
        this.stage = stage;
        this.statusCode = statusCode;
    }

    @Override
    public void close() {
        AppThread.exec(this.statusCode, new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ((Stage)WindowServer.this.stage.get()).close();
                return null;
            }
        });
    }

    public org.openqa.selenium.Point getPosition() {
        return this.remoteGetPosition().toSelenium();
    }

    @Override
    public Point remoteGetPosition() {
        return AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Point>(){

            @Override
            public Point perform() {
                return new Point((int)Math.rint(((Stage)WindowServer.this.stage.get()).getX()), (int)Math.rint(((Stage)WindowServer.this.stage.get()).getY()));
            }
        });
    }

    public org.openqa.selenium.Dimension getSize() {
        return this.remoteGetSize().toSelenium();
    }

    @Override
    public Dimension remoteGetSize() {
        return AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Dimension>(){

            @Override
            public Dimension perform() {
                return new Dimension((int)Math.rint(((Stage)WindowServer.this.stage.get()).getWidth()), (int)Math.rint(((Stage)WindowServer.this.stage.get()).getHeight()));
            }
        });
    }

    @Override
    public void maximize() {
        AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ((Stage)WindowServer.this.stage.get()).setMaximized(!((Stage)WindowServer.this.stage.get()).isMaximized());
                return null;
            }
        });
    }

    public void setPosition(final org.openqa.selenium.Point point) {
        AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                if (!((Stage)WindowServer.this.stage.get()).isFullScreen()) {
                    int screenWidth = SettingsManager.settings().screenWidth();
                    int screenHeight = SettingsManager.settings().screenHeight();
                    int width = (int)Math.rint(((Stage)WindowServer.this.stage.get()).getWidth());
                    int height = (int)Math.rint(((Stage)WindowServer.this.stage.get()).getHeight());
                    int newX = Math.max(0, Math.min(screenWidth - width, point.getX()));
                    int newY = Math.max(0, Math.min(screenHeight - height, point.getY()));
                    ((Stage)WindowServer.this.stage.get()).hide();
                    ((Stage)WindowServer.this.stage.get()).setMaximized(false);
                    ((Stage)WindowServer.this.stage.get()).setX((double)newX);
                    ((Stage)WindowServer.this.stage.get()).setY((double)newY);
                    ((Stage)WindowServer.this.stage.get()).show();
                }
                return null;
            }
        });
    }

    @Override
    public void remoteSetPosition(Point point) {
        this.setPosition(point.toSelenium());
    }

    public void setSize(final org.openqa.selenium.Dimension dimension) {
        AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                if (!((Stage)WindowServer.this.stage.get()).isFullScreen()) {
                    int screenWidth = SettingsManager.settings().screenWidth();
                    int screenHeight = SettingsManager.settings().screenHeight();
                    int xPos = (int)Math.rint(((Stage)WindowServer.this.stage.get()).getX());
                    int yPos = (int)Math.rint(((Stage)WindowServer.this.stage.get()).getY());
                    if (dimension.getWidth() > screenWidth - xPos && xPos > 0 || dimension.getHeight() > screenHeight - yPos && yPos > 0) {
                        xPos = 0;
                        yPos = 0;
                    }
                    int newWidth = Math.max(0, Math.min(screenWidth - xPos, dimension.getWidth()));
                    int newHeight = Math.max(0, Math.min(screenHeight - yPos, dimension.getHeight()));
                    ((Stage)WindowServer.this.stage.get()).hide();
                    ((Stage)WindowServer.this.stage.get()).setMaximized(false);
                    ((Stage)WindowServer.this.stage.get()).setX((double)xPos);
                    ((Stage)WindowServer.this.stage.get()).setY((double)yPos);
                    ((Stage)WindowServer.this.stage.get()).setWidth((double)newWidth);
                    ((Stage)WindowServer.this.stage.get()).setHeight((double)newHeight);
                    ((Stage)WindowServer.this.stage.get()).show();
                }
                return null;
            }
        });
    }

    @Override
    public void remoteSetSize(Dimension dimension) {
        this.setSize(dimension.toSelenium());
    }

    @Override
    public void fullscreen() {
        AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Object>(){

            @Override
            public Object perform() {
                ((Stage)WindowServer.this.stage.get()).setFullScreen(!((Stage)WindowServer.this.stage.get()).isFullScreen());
                return null;
            }
        });
    }
}

