/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.glass.ui.monocle.HeadlessPlatform;
import com.machinepublishers.glass.ui.monocle.MonoclePlatformFactory;
import com.machinepublishers.glass.ui.monocle.NativePlatformFactory;
import com.machinepublishers.jbrowserdriver.App;
import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.LogsServer;
import com.machinepublishers.jbrowserdriver.ProxyAuth;
import com.machinepublishers.jbrowserdriver.Settings;
import com.machinepublishers.jbrowserdriver.StreamConnection;
import com.machinepublishers.jbrowserdriver.Util;
import com.sun.glass.ui.Application;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.embed.swing.JFXPanel;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

class SettingsManager {
    private static final AtomicReference<Settings> settings = new AtomicReference();
    private static final AtomicBoolean platformInitialized = new AtomicBoolean();
    private static final AtomicBoolean monocle = new AtomicBoolean();

    SettingsManager() {
    }

    static boolean isMonocle() {
        if (!platformInitialized.get()) {
            throw new IllegalStateException();
        }
        return monocle.get();
    }

    static Settings settings() {
        return settings.get();
    }

    static void register(Settings settings) {
        SettingsManager.settings.set(settings);
        if (settings != null) {
            LogsServer.updateSettings();
            StreamConnection.updateSettings();
            if (settings.headless() && platformInitialized.compareAndSet(false, true)) {
                monocle.set(true);
                System.setProperty("quantum.multithreaded", "false");
                System.setProperty("prism.vsync", "true");
                System.setProperty("javafx.animation.framerate", "1");
                System.setProperty("com.sun.scenario.animation.adaptivepulse", "true");
                System.setProperty("quantum.singlethreaded", "true");
                System.setProperty("prism.threadcheck", "false");
                System.setProperty("prism.dirtyopts", "false");
                System.setProperty("prism.cacheshapes", "false");
                System.setProperty("prism.primtextures", "false");
                System.setProperty("prism.shutdownHook", "false");
                System.setProperty("prism.disableRegionCaching", "true");
                System.setProperty("glass.platform", "Monocle");
                System.setProperty("monocle.platform", "Headless");
                System.setProperty("prism.order", "sw");
                System.setProperty("prism.allowhidpi", "false");
                System.setProperty("prism.text", "t2k");
                try {
                    Class<?> platformFactory = Class.forName("com.sun.glass.ui.PlatformFactory");
                    Field field = platformFactory.getDeclaredField("instance");
                    field.setAccessible(true);
                    field.set(platformFactory, (Object)new MonoclePlatformFactory());
                    NativePlatformFactory.setPlatform(new HeadlessPlatform());
                }
                catch (Throwable t) {
                    Util.handleException(t);
                }
            } else if (platformInitialized.compareAndSet(false, true)) {
                new JFXPanel();
            }
        }
    }

    static void register(AtomicReference<Stage> stage, AtomicReference<WebView> view) {
        ProxyAuth.add(settings.get().proxy());
        if (SettingsManager.isMonocle() && Application.GetApplication() == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        javafx.application.Application.launch(App.class, (String[])new String[]{Integer.toString(((Settings)settings.get()).screenWidth()), Integer.toString(((Settings)settings.get()).screenHeight()), Boolean.toString(SettingsManager.isMonocle())});
                    }
                    catch (Throwable t) {
                        LogsServer.instance().exception(t);
                    }
                }
            }).start();
        } else {
            final App app = new App();
            app.init(settings.get().screenWidth(), settings.get().screenHeight(), SettingsManager.isMonocle());
            AppThread.exec(new AtomicInteger(-1), new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    try {
                        app.start();
                    }
                    catch (Throwable t) {
                        LogsServer.instance().exception(t);
                    }
                    return null;
                }
            });
        }
        stage.set(App.getStage());
        view.set(App.getView());
    }
}

