/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.ImeHandlerRemote;
import com.machinepublishers.jbrowserdriver.SocketLock;
import com.machinepublishers.jbrowserdriver.Util;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;

class ImeHandler
implements WebDriver.ImeHandler {
    private final ImeHandlerRemote remote;
    private final SocketLock lock;

    ImeHandler(ImeHandlerRemote remote, SocketLock lock) {
        this.remote = remote;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateEngine(String name) {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.activateEngine(name);
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                this.remote.deactivate();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActiveEngine() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getActiveEngine();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAvailableEngines() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.getAvailableEngines();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return new ArrayList<String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isActivated() {
        try {
            SocketLock socketLock = this.lock;
            synchronized (socketLock) {
                return this.remote.isActivated();
            }
        }
        catch (Throwable t) {
            Util.handleException(t);
            return false;
        }
    }
}

