/*
 * Decompiled with CFR 0.152.
 */
package com.machinepublishers.jbrowserdriver;

import com.machinepublishers.jbrowserdriver.AppThread;
import com.machinepublishers.jbrowserdriver.Context;
import com.machinepublishers.jbrowserdriver.ElementServer;
import com.machinepublishers.jbrowserdriver.Frames;
import com.machinepublishers.jbrowserdriver.HttpListener;
import com.machinepublishers.jbrowserdriver.JBrowserDriverServer;
import com.machinepublishers.jbrowserdriver.PopupHandler;
import com.machinepublishers.jbrowserdriver.SettingsManager;
import com.machinepublishers.jbrowserdriver.Util;
import com.machinepublishers.jbrowserdriver.WindowServer;
import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.LoadListenerClient;
import com.sun.webkit.WebPage;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;
import netscape.javascript.JSObject;
import org.openqa.selenium.Point;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class ContextItem {
    private static final AtomicLong currentItemId = new AtomicLong();
    final AtomicReference<WindowServer> window = new AtomicReference();
    final AtomicReference<Stage> stage = new AtomicReference();
    final AtomicReference<WebView> view = new AtomicReference();
    final AtomicReference<WebEngine> engine = new AtomicReference();
    final AtomicReference<HttpListener> httpListener = new AtomicReference();
    final AtomicBoolean initialized = new AtomicBoolean();
    final AtomicReference<String> itemId = new AtomicReference();
    final AtomicReference<Context> context = new AtomicReference();
    private final Frames frames = new Frames();
    private ElementServer frame;

    ContextItem() {
        this.itemId.set(Long.toString(currentItemId.getAndIncrement()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ElementServer selectedFrame() {
        Frames frames = this.frames;
        synchronized (frames) {
            if (!(this.frame == null || this.frame.node() instanceof Document && this.frames.conatins(this.frame.node()))) {
                boolean foundFrame = false;
                try {
                    Document doc;
                    if (this.frame.frameId() > 0L && (doc = Accessor.getPageFor((WebEngine)this.engine.get()).getDocument(this.frame.frameId())) instanceof JSObject) {
                        this.selectFrame(new ElementServer((JSObject)((Object)doc), this.context.get()));
                        foundFrame = true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!foundFrame) {
                    this.deselectFrame();
                }
            }
            return this.frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsFrame(JSObject doc) {
        Frames frames = this.frames;
        synchronized (frames) {
            return this.frames.conatins(doc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Point selectedFrameLocation() {
        Frames frames = this.frames;
        synchronized (frames) {
            ElementServer selectedFrame = this.selectedFrame();
            int xCoord = 0;
            int yCoord = 0;
            if (selectedFrame != null) {
                long frameId = this.frames.id(selectedFrame.node());
                WebPage webPage = Accessor.getPageFor((WebEngine)this.engine.get());
                List<Long> ancestors = this.frames.ancestors(frameId);
                ancestors.add(frameId);
                for (Long curFrameId : ancestors) {
                    try {
                        Element owner = webPage.getOwnerElement(curFrameId.longValue());
                        if (!(owner instanceof JSObject)) continue;
                        Point point = new ElementServer((JSObject)((Object)owner), this.context.get()).getLocation();
                        xCoord += point.getX();
                        yCoord += point.getY();
                    }
                    catch (RemoteException e) {
                        Util.handleException(e);
                    }
                }
            }
            return new Point(xCoord, yCoord);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deselectFrame() {
        Frames frames = this.frames;
        synchronized (frames) {
            this.frame = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void selectFrame(ElementServer frame) {
        Frames frames = this.frames;
        synchronized (frames) {
            frame.setFrameId(this.frames.id(frame.node()));
            this.frame = frame;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFrameId(long frameId) {
        Frames frames = this.frames;
        synchronized (frames) {
            this.frames.reset(frameId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFrameId(long frameId) {
        Frames frames = this.frames;
        synchronized (frames) {
            WebPage webPage = Accessor.getPageFor((WebEngine)this.engine.get());
            this.frames.add(frameId, (JSObject)((Object)webPage.getDocument(frameId)), (JSObject)((Object)webPage.getOwnerElement(frameId)), webPage.getParentFrame(frameId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long currentFrameId() {
        Frames frames = this.frames;
        synchronized (frames) {
            ElementServer selectedFrame = this.selectedFrame();
            long selectedId = selectedFrame == null ? 0L : this.frames.id(selectedFrame.node());
            return selectedId == 0L ? this.frames.rootId() : selectedId;
        }
    }

    void init(final JBrowserDriverServer driver, final Context context) {
        if (this.initialized.compareAndSet(false, true)) {
            this.context.set(context);
            SettingsManager.register(this.stage, this.view);
            this.engine.set(this.view.get().getEngine());
            try {
                this.window.set(new WindowServer(this.stage, context.statusCode));
                context.alert.get().listen(this);
            }
            catch (RemoteException e) {
                Util.handleException(e);
            }
            final ContextItem thisObject = this;
            AppThread.exec(context.statusCode, new AppThread.Sync<Object>(){

                @Override
                public Object perform() {
                    ContextItem.this.engine.get().setJavaScriptEnabled(SettingsManager.settings().javascript());
                    ContextItem.this.httpListener.set(new HttpListener(thisObject, context.statusCode, context.timeouts.get().getPageLoadTimeoutObjMS()));
                    Accessor.getPageFor((WebEngine)ContextItem.this.view.get().getEngine()).addLoadListenerClient((LoadListenerClient)ContextItem.this.httpListener.get());
                    ContextItem.this.engine.get().setCreatePopupHandler((Callback)new PopupHandler(driver, context));
                    return null;
                }
            });
        }
    }
}

