/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins.validation;

import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablStepBuilder;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class MablStepBuilderValidator {
    public static FormValidation validateForm(String restApiKeyName, String environmentId, String applicationId, Job job) {
        return MablStepBuilderValidator.validateForm(restApiKeyName, environmentId, applicationId, false, job);
    }

    public static FormValidation validateForm(String restApiKeyId, String environmentId, String applicationId, boolean disableSslVerification, Job job) {
        try {
            String restApiKeyClean = StringUtils.trimToNull((String)restApiKeyId);
            String applicationIdClean = StringUtils.trimToNull((String)applicationId);
            String environmentIdClean = StringUtils.trimToNull((String)environmentId);
            if (restApiKeyClean == null) {
                return FormValidation.error((String)"Non-empty %s required", (Object[])new Object[]{"API Key"});
            }
            if (restApiKeyClean.contains("key:")) {
                return FormValidation.error((String)"Invalid %s", (Object[])new Object[]{"API Key"});
            }
            if (environmentIdClean != null && environmentIdClean.endsWith("-a")) {
                return FormValidation.error((String)"Invalid %s value. Contains an %s", (Object[])new Object[]{"Application ID", "Environment ID"});
            }
            if (applicationIdClean != null && applicationIdClean.endsWith("-e")) {
                return FormValidation.error((String)"Invalid %s value. Contains an %s", (Object[])new Object[]{"Environment ID", "Application ID"});
            }
            if (environmentIdClean == null && applicationIdClean == null) {
                return FormValidation.error((String)"Non-empty %s or %s required", (Object[])new Object[]{"Environment ID", "Application ID"});
            }
            try {
                MablRestApiClient client = MablStepBuilder.createMablRestApiClient(restApiKeyClean, disableSslVerification, job);
                client.checkConnection();
            }
            catch (IOException e) {
                return FormValidation.error((String)("Failed to connect to mabl API: " + e.getMessage()));
            }
            return FormValidation.okWithMarkup((String)"<span style='color:green'>\u2713 Everything looks good</span>");
        }
        catch (Exception e) {
            return FormValidation.error((String)("Client error : " + e.getMessage()));
        }
    }
}

