/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.common.base.Strings;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import hudson.EnvVars;
import java.io.PrintStream;
import java.util.Map;

public class Converter {
    public static CreateDeploymentProperties convert(EnvVars vars, PrintStream outputStream) {
        CreateDeploymentProperties props = new CreateDeploymentProperties();
        props.setRepositoryBranchName(Converter.getProperty(vars, outputStream, new String[]{"GIT_BRANCH"}));
        props.setRepositoryRevisionNumber(Converter.getProperty(vars, outputStream, new String[]{"GIT_COMMIT", "SVN_REVISION"}));
        String repoUrl = Converter.getProperty(vars, outputStream, new String[]{"GIT_URL", "SVN_URL"});
        props.setRepositoryUrl(repoUrl);
        props.setRepositoryName(Converter.getRepositoryName(repoUrl));
        props.setRepositoryPreviousRevisionNumber(Converter.getProperty(vars, outputStream, new String[]{"GIT_PREVIOUS_COMMIT"}));
        props.setBuildPlanId(Converter.getProperty(vars, outputStream, new String[]{"JOB_NAME"}));
        props.setBuildPlanName(Converter.getProperty(vars, outputStream, new String[]{"JOB_NAME"}));
        props.setBuildPlanNumber(Converter.getProperty(vars, outputStream, new String[]{"BUILD_NUMBER"}));
        props.setBuildPlanResultUrl(Converter.getProperty(vars, outputStream, new String[]{"RUN_DISPLAY_URL"}));
        return props;
    }

    private static <String> String getProperty(Map<String, String> vars, PrintStream stream, String ... possibleProperties) {
        for (String property : possibleProperties) {
            if (!vars.containsKey(property)) continue;
            stream.printf("  '%s' => '%s'%n", property, vars.get(property));
            return vars.get(property);
        }
        return null;
    }

    private static String getRepositoryName(String repoUrl) {
        if (!Strings.isNullOrEmpty((String)repoUrl)) {
            String[] segments = repoUrl.split("/");
            String ending = segments[segments.length - 1];
            return ending.endsWith(".git") ? ending.substring(0, ending.length() - 4) : ending;
        }
        return null;
    }
}

