/*
 * Decompiled with CFR 0.152.
 */
package com.mabl.integration.jenkins;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.mabl.integration.jenkins.JenkinsModule;
import com.mabl.integration.jenkins.MablRestApiClient;
import com.mabl.integration.jenkins.MablRestApiClientRetryHandler;
import com.mabl.integration.jenkins.MablStepConstants;
import com.mabl.integration.jenkins.MablSystemException;
import com.mabl.integration.jenkins.domain.CreateDeploymentPayload;
import com.mabl.integration.jenkins.domain.CreateDeploymentProperties;
import com.mabl.integration.jenkins.domain.CreateDeploymentResult;
import com.mabl.integration.jenkins.domain.ExecutionResult;
import com.mabl.integration.jenkins.domain.GetApiKeyResult;
import com.mabl.integration.jenkins.domain.GetApplicationsResult;
import com.mabl.integration.jenkins.domain.GetEnvironmentsResult;
import com.mabl.integration.jenkins.domain.GetLabelsResult;
import hudson.ProxyConfiguration;
import hudson.util.Secret;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;

public class MablRestApiClientImpl
implements MablRestApiClient {
    private final Gson gson = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    static final String REST_API_USERNAME_PLACEHOLDER = "key";
    static final String DEPLOYMENT_TRIGGER_ENDPOINT = "/events/deployment";
    static final String DEPLOYMENT_RESULT_ENDPOINT_TEMPLATE = "/execution/result/event/%s";
    static final String GET_ORGANIZATION_ENDPOINT_TEMPLATE = "/apiKeys/self";
    static final String GET_APPLICATIONS_ENDPOINT_TEMPLATE = "/applications?organization_id=%s";
    static final String GET_ENVIRONMENTS_ENDPOINT_TEMPLATE = "/environments?organization_id=%s";
    static final String GET_LABELS_ENDPOINT_TEMPLATE = "/schedule/runPolicy/labels?organization_id=%s";
    static final String HEALTH_LIVE_ENDPOINT = "/health/live";
    private static final Header JSON_TYPE_HEADER = new BasicHeader("Content-Type", "application/json");
    private final CloseableHttpClient httpClient;
    private final String restApiBaseUrl;
    private final Secret restApiKey;
    private final String appBaseUrl;
    private ProxyConfiguration proxy;

    MablRestApiClientImpl(String restApiBaseUrl, Secret restApiKey, String appBaseUrl) {
        this(restApiBaseUrl, restApiKey, appBaseUrl, false);
    }

    MablRestApiClientImpl(String restApiBaseUrl, Secret restApiKey, String appBaseUrl, boolean disableSslVerification) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins != null) {
            this.proxy = jenkins.proxy;
        }
        this.restApiKey = restApiKey;
        this.restApiBaseUrl = restApiBaseUrl;
        this.appBaseUrl = appBaseUrl;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)this.getRetryHandler()).setDefaultCredentialsProvider(this.getApiCredentialsProvider(restApiKey)).setUserAgent(MablStepConstants.PLUGIN_USER_AGENT).setConnectionTimeToLive(10L, TimeUnit.MINUTES).setRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(3, true)).setDefaultRequestConfig(this.getDefaultRequestConfig());
        if (disableSslVerification) {
            SSLContext sslContext;
            try {
                sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustAllStrategy()).build();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing SSL", e);
            }
            httpClientBuilder.setSSLContext(sslContext);
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry));
        }
        this.httpClient = httpClientBuilder.build();
    }

    private MablRestApiClientRetryHandler getRetryHandler() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new JenkinsModule()});
        return (MablRestApiClientRetryHandler)injector.getInstance(MablRestApiClientRetryHandler.class);
    }

    private CredentialsProvider getApiCredentialsProvider(Secret restApiKey) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        UsernamePasswordCredentials creds = new UsernamePasswordCredentials(REST_API_USERNAME_PLACEHOLDER, restApiKey.getPlainText());
        provider.setCredentials(AuthScope.ANY, (Credentials)creds);
        if (!(this.proxy == null || StringUtils.isBlank((String)this.proxy.getUserName()) && StringUtils.isBlank((String)this.proxy.getPassword()))) {
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(this.proxy.getUserName() == null ? "" : this.proxy.getUserName(), this.proxy.getPassword());
            provider.setCredentials(new AuthScope(new HttpHost(this.proxy.name, this.proxy.port)), (Credentials)credentials);
        }
        return provider;
    }

    private Header getBasicAuthHeader(Secret restApiKey) {
        String encoded = Base64.getMimeEncoder().encodeToString(("key:" + restApiKey.getPlainText()).getBytes(StandardCharsets.UTF_8));
        return new BasicHeader("Authorization", "Basic " + encoded);
    }

    @Override
    public CreateDeploymentResult createDeploymentEvent(String environmentId, String applicationId, String labels, String mablBranch, CreateDeploymentProperties properties) throws IOException {
        String url = this.restApiBaseUrl + DEPLOYMENT_TRIGGER_ENDPOINT;
        String jsonPayload = this.gson.toJson((Object)new CreateDeploymentPayload(environmentId, applicationId, labels, mablBranch, properties));
        ByteArrayEntity payloadEntity = new ByteArrayEntity(jsonPayload.getBytes(StandardCharsets.UTF_8));
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)payloadEntity);
        request.addHeader(this.getBasicAuthHeader(this.restApiKey));
        request.addHeader(JSON_TYPE_HEADER);
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)request), CreateDeploymentResult.class);
    }

    @Override
    public ExecutionResult getExecutionResults(String eventId) throws IOException {
        String url = this.restApiBaseUrl + String.format(DEPLOYMENT_RESULT_ENDPOINT_TEMPLATE, eventId);
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url)), ExecutionResult.class);
    }

    @Override
    public GetApiKeyResult getApiKeyResult() throws IOException {
        String url = this.restApiBaseUrl + GET_ORGANIZATION_ENDPOINT_TEMPLATE;
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url)), GetApiKeyResult.class);
    }

    @Override
    public GetApplicationsResult getApplicationsResult(String organizationId) throws IOException {
        String url = this.restApiBaseUrl + String.format(GET_APPLICATIONS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url)), GetApplicationsResult.class);
    }

    @Override
    public GetEnvironmentsResult getEnvironmentsResult(String organizationId) throws IOException {
        String url = this.restApiBaseUrl + String.format(GET_ENVIRONMENTS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url)), GetEnvironmentsResult.class);
    }

    @Override
    public GetLabelsResult getLabelsResult(String organizationId) throws IOException {
        String url = this.restApiBaseUrl + String.format(GET_LABELS_ENDPOINT_TEMPLATE, organizationId);
        return this.parseApiResult((HttpResponse)this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url)), GetLabelsResult.class);
    }

    @Override
    public String getAppBaseUrl() {
        return this.appBaseUrl;
    }

    @Override
    public void checkConnection() throws IOException {
        String url = this.restApiBaseUrl + HEALTH_LIVE_ENDPOINT;
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.buildGetRequest(url));
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 200: {
                break;
            }
            case 401: {
                throw new IOException("Invalid API key provided or the proxy connection requires authentication");
            }
            case 403: {
                throw new IOException("Invalid API key type. You must use a 'CI/CD Integration' key type");
            }
            default: {
                throw new IOException(response.getStatusLine().toString());
            }
        }
    }

    private HttpGet buildGetRequest(String url) {
        try {
            HttpGet request = new HttpGet(url);
            request.addHeader(this.getBasicAuthHeader(this.restApiKey));
            return request;
        }
        catch (IllegalArgumentException e) {
            throw new MablSystemException("Unexpected status from mabl trying to build API url: %s", url);
        }
    }

    private <ApiResult> ApiResult parseApiResult(HttpResponse response, Class<ApiResult> resultClass) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 200: 
            case 201: {
                Object result = null;
                try (InputStream responseStream = response.getEntity().getContent();){
                    result = this.gson.fromJson(new JsonReader((Reader)new InputStreamReader(responseStream, StandardCharsets.UTF_8)), resultClass);
                }
                return (ApiResult)result;
            }
            case 404: {
                return null;
            }
        }
        throw new MablSystemException("Unexpected status from mabl API on result fetch: %d%nbody: [%s]%n", statusCode, EntityUtils.toString((HttpEntity)response.getEntity()));
    }

    private RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(600000).setConnectionRequestTimeout(600000).setSocketTimeout(600000).setProxy(this.proxy != null ? new HttpHost(this.proxy.name, this.proxy.port) : null).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).setTargetPreferredAuthSchemes(Collections.singletonList("Basic")).build();
    }

    @Override
    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

