/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.m14n.android.ex.Resource;
import java.util.ArrayList;

public final class ExA {
    private ExA() {
    }

    public static int getCenterOfView(View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    public static String[] getDeniedPermissions(Context context, String[] requestedPermissions) {
        ArrayList<String> theDeniedPermissions = new ArrayList<String>(requestedPermissions.length);
        for (String theRequestedPermission : requestedPermissions) {
            if (ContextCompat.checkSelfPermission((Context)context, (String)theRequestedPermission) == 0) continue;
            theDeniedPermissions.add(theRequestedPermission);
        }
        return theDeniedPermissions.toArray(new String[0]);
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connMgr == null ? null : connMgr.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static void prepareDBForDowloading(Context context, String dbFileName) {
        new SQLiteOpenHelper(context, dbFileName, null, 1){

            public void onCreate(SQLiteDatabase sqLiteDatabase) {
            }

            public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {
            }
        }.getWritableDatabase().close();
    }

    public static void updateResource(@NonNull Resource<?> date, View progress, View error, View resource) {
        if (progress != null) {
            progress.setVisibility(Resource.Status.LOADING.equals((Object)date.status) ? 0 : 4);
        }
        if (error != null) {
            error.setVisibility(Resource.Status.ERROR.equals((Object)date.status) ? 0 : 4);
        }
        if (resource != null) {
            resource.setVisibility(Resource.Status.SUCCESS.equals((Object)date.status) ? 0 : 4);
        }
    }
}

