/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.FragmentActivity;
import com.m14n.android.ex.AlertDialogFragment;
import com.m14n.android.ex.ProgressDialogFragment;

public final class Alerts {
    static final String TITLE_KEY = "title";
    static final String MESSAGE_KEY = "message";

    private Alerts() {
    }

    public static void showOk(FragmentActivity activity, String tag, int titleId, int messageId) {
        Alerts.show(activity, tag, titleId, messageId, 17039370, 0, 0);
    }

    public static void showOkCancel(FragmentActivity activity, String tag, int titleId, int messageId) {
        Alerts.show(activity, tag, titleId, messageId, 17039370, 0, 0x1040000);
    }

    public static void show(FragmentActivity activity, String tag, int titleId, int messageId, int positiveId, int neutralId, int negativeId) {
        DialogFragment dialogFragment = AlertDialogFragment.create(titleId, messageId, positiveId, neutralId, negativeId);
        Alerts.setAndShow(dialogFragment, activity, tag);
    }

    public static void showProgress(FragmentActivity activity, String tag, int titleId, int messageId) {
        DialogFragment dialogFragment = ProgressDialogFragment.create(titleId, messageId);
        Alerts.setAndShow(dialogFragment, activity, tag);
    }

    private static void setAndShow(DialogFragment dialogFragment, FragmentActivity activity, String tag) {
        dialogFragment.setCancelable(false);
        dialogFragment.show(activity.getSupportFragmentManager(), tag);
    }

    public static void close(FragmentActivity activity, String tag) {
        try {
            DialogFragment fragment = (DialogFragment)activity.getSupportFragmentManager().findFragmentByTag(tag);
            if (fragment != null) {
                fragment.dismiss();
            }
        }
        catch (ClassCastException e) {
            new IllegalArgumentException("The tag " + tag + " must be of DialogFragment!");
        }
    }
}

