package com.m14n.android.ex.anim;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

public class ShowAnimation extends Animation {
    private float centerX;
    private float centerY;
    private final Camera camera = new Camera();

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        centerX = width / 2.0f;
        centerY = height / 2.0f;
    }

    @Override
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        camera.save();
        final float angle = (interpolatedTime - 1) * 90.0f;
        camera.rotateY(angle);
        Matrix m = t.getMatrix();
        camera.getMatrix(m);
        camera.restore();
        m.preTranslate(-centerX, -centerY);
        m.postTranslate(centerX, centerY);
    }
}
