package com.m14n.android.ex;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.util.AttributeSet;

import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageView;

import com.m14n.R;

public class RoundedImageView extends AppCompatImageView {
    private float mRadius;
    private float mClipSize;
    private final Path mClipPath = new Path();
    private final RectF mClipRect = new RectF();

    public RoundedImageView(Context context) {
        super(context);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initAttrs(context, attrs);
    }

    public RoundedImageView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initAttrs(context, attrs);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.RoundedImageView, 0, 0);

        try {
            mRadius = a.getDimension(R.styleable.RoundedImageView_cornerRadius, 0.0f);
            mClipSize = a.getDimension(R.styleable.RoundedImageView_clipSize, 0.0f);
        } finally {
            a.recycle();
        }
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        mClipRect.left = mClipSize;
        mClipRect.top = mClipSize;
        mClipRect.bottom = this.getMeasuredHeight() - mClipSize;
        mClipRect.right = this.getMeasuredWidth() - mClipSize;
        mClipPath.reset();
        mClipPath.addRoundRect(mClipRect, mRadius, mRadius, Path.Direction.CW);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        canvas.clipPath(mClipPath);
        super.onDraw(canvas);
    }
}
