/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import com.m14n.ex.Ex;
import java.util.Calendar;

public class DatePickerFragment
extends DialogFragment {
    private static final String KEY_YEAR = "keyYear";
    private static final String KEY_MONTH = "keyMonth";
    private static final String KEY_DAY = "keyDay";
    private static final String KEY_MIN_DATE = "keyMinDate";
    private static final String KEY_MAX_DATE = "keyMaxDate";
    private static final String KEY_TITLE = "keyTitle";
    private DatePickerDialog.OnDateSetListener mDateListener;

    public static DatePickerFragment create(String title, int year, int month, int day, Long minDate, Long maxDate) {
        DatePickerFragment fragment = new DatePickerFragment();
        Bundle args = new Bundle();
        args.putString(KEY_TITLE, title);
        args.putInt(KEY_YEAR, year);
        args.putInt(KEY_MONTH, month);
        args.putInt(KEY_DAY, day);
        args.putLong(KEY_MIN_DATE, minDate != null ? minDate : Long.MIN_VALUE);
        args.putLong(KEY_MAX_DATE, maxDate != null ? maxDate : Long.MAX_VALUE);
        fragment.setArguments(args);
        return fragment;
    }

    public void setDateListener(DatePickerDialog.OnDateSetListener dateListener) {
        this.mDateListener = dateListener;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        String theTitle;
        long maxDate;
        Bundle theArguments = this.getArguments();
        int year = theArguments.getInt(KEY_YEAR);
        int month = theArguments.getInt(KEY_MONTH);
        int day = theArguments.getInt(KEY_DAY);
        DatePickerDialog theDatePickerDialog = new DatePickerDialog(this.getContext(), this.getTheme(), this.mDateListener, year, month, day);
        long minDate = theArguments.getLong(KEY_MIN_DATE);
        if (minDate != Long.MIN_VALUE) {
            theDatePickerDialog.getDatePicker().setMinDate(minDate);
        }
        if ((maxDate = theArguments.getLong(KEY_MAX_DATE)) != Long.MAX_VALUE) {
            theDatePickerDialog.getDatePicker().setMaxDate(maxDate);
        }
        if (Ex.isNotEmpty((String)(theTitle = theArguments.getString(KEY_TITLE)))) {
            theDatePickerDialog.setTitle((CharSequence)theTitle);
        }
        return theDatePickerDialog;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String mTitle;
        private long mDate;
        private long mMinDate;
        private long mMaxDate;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setDate(long date) {
            this.mDate = date;
            return this;
        }

        public Builder setMinDate(long minDate) {
            this.mMinDate = minDate;
            return this;
        }

        public Builder setMaxDate(long maxDate) {
            this.mMaxDate = maxDate;
            return this;
        }

        public DatePickerFragment build() {
            Calendar theCalendar = Calendar.getInstance();
            theCalendar.setTimeInMillis(this.mDate);
            return DatePickerFragment.create(this.mTitle, theCalendar.get(1), theCalendar.get(2), theCalendar.get(5), this.mMinDate, this.mMaxDate);
        }
    }
}

