package com.m14n.android.ex;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class ProgressDialogFragment extends DialogFragment {
    public static DialogFragment create(int titleId, int messageId) {
        DialogFragment fragment = new ProgressDialogFragment();
        final Bundle args = new Bundle();
        args.putInt(Alerts.TITLE_KEY, titleId);
        args.putInt(Alerts.MESSAGE_KEY, messageId);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final Bundle args = getArguments();
        final Activity activity = getActivity();
        final ProgressDialog dialog = new ProgressDialog(activity);
        final int titleId = args.getInt(Alerts.TITLE_KEY);
        if (titleId != 0) {
            dialog.setTitle(titleId);
        }
        final int messageId = args.getInt(Alerts.MESSAGE_KEY);
        if (messageId != 0) {
            dialog.setMessage(activity.getString(messageId));
        }
        dialog.setIndeterminate(true);
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        return dialog;
    }
}
