package com.m14n.android.ex;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.view.View;

import java.util.ArrayList;
import java.util.List;

public final class ExA {
    private ExA() {
    }

    public static int getCenterOfView(final View view) {
        return view.getLeft() + view.getWidth() / 2;
    }

    public static String[] getDeniedPermissions(Context context, String[] requestedPermissions) {
        final List<String> theDeniedPermissions = new ArrayList<>(requestedPermissions.length);
        for (String theRequestedPermission : requestedPermissions) {
            if (ContextCompat.checkSelfPermission(context, theRequestedPermission) !=
                    PackageManager.PERMISSION_GRANTED) {
                theDeniedPermissions.add(theRequestedPermission);
            }
        }
        return theDeniedPermissions.toArray(new String[0]);
    }

    public static boolean isOnline(Context context) {
        ConnectivityManager connMgr = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = connMgr == null ? null : connMgr.getActiveNetworkInfo();
        return (networkInfo != null && networkInfo.isConnected());
    }

    public static void prepareDBForDowloading(Context context, String dbFileName) {
        new SQLiteOpenHelper(context, dbFileName, null, 1) {
            @Override
            public void onCreate(SQLiteDatabase sqLiteDatabase) {

            }

            @Override
            public void onUpgrade(SQLiteDatabase sqLiteDatabase, int i, int i1) {

            }
        }.getWritableDatabase().close();
    }

    public static void updateResource(@NonNull Resource<?> date, View progress, View error, View resource) {
        if (progress != null) {
            progress.setVisibility(Resource.Status.LOADING.equals(date.status) ? View.VISIBLE : View.INVISIBLE);
        }
        if (error != null) {
            error.setVisibility(Resource.Status.ERROR.equals(date.status) ? View.VISIBLE : View.INVISIBLE);
        }
        if (resource != null) {
            resource.setVisibility(Resource.Status.SUCCESS.equals(date.status) ? View.VISIBLE : View.INVISIBLE);
        }
    }
}