/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class Resource<T> {
    @NonNull
    public final Status status;
    @Nullable
    public final String message;
    @Nullable
    public final T data;

    public Resource(@NonNull Status status, @Nullable T data, @Nullable String message) {
        this.status = status;
        this.data = data;
        this.message = message;
    }

    public static <T> Resource<T> success(@Nullable T data) {
        return new Resource<T>(Status.SUCCESS, data, null);
    }

    public static <T> Resource<T> error(String msg, @Nullable T data) {
        return new Resource<T>(Status.ERROR, data, msg);
    }

    public static <T> Resource<T> error(String msg) {
        return new Resource<Object>(Status.ERROR, null, msg);
    }

    public static <T> Resource<T> loading(@Nullable T data) {
        return new Resource<T>(Status.LOADING, data, null);
    }

    public static <T> Resource<T> loading() {
        return new Resource<Object>(Status.LOADING, null, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resource resource = (Resource)o;
        if (this.status != resource.status) {
            return false;
        }
        return (this.message != null ? this.message.equals(resource.message) : resource.message == null) && (this.data != null ? this.data.equals(resource.data) : resource.data == null);
    }

    public int hashCode() {
        int result = this.status.hashCode();
        result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Resource{status=" + (Object)((Object)this.status) + ", message='" + this.message + '\'' + ", data=" + this.data + '}';
    }

    public static enum Status {
        SUCCESS,
        ERROR,
        LOADING;

    }
}

