/*
 * Decompiled with CFR 0.152.
 */
package com.m14n.android.ex;

import android.app.DatePickerDialog;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class DatePickerFragment
extends DialogFragment {
    private static final String KEY_YEAR = "keyYear";
    private static final String KEY_MONTH = "keyMonth";
    private static final String KEY_DAY = "keyDay";
    private static final String KEY_MIN_DATE = "keyMinDate";
    private static final String KEY_MAX_DATE = "keyMaxDate";
    private DatePickerDialog.OnDateSetListener mDateListener;

    public static DatePickerFragment create(int year, int month, int day, Long minDate, Long maxDate) {
        DatePickerFragment fragment = new DatePickerFragment();
        Bundle args = new Bundle();
        args.putInt(KEY_YEAR, year);
        args.putInt(KEY_MONTH, month);
        args.putInt(KEY_DAY, day);
        args.putLong(KEY_MIN_DATE, minDate != null ? minDate : Long.MIN_VALUE);
        args.putLong(KEY_MAX_DATE, maxDate != null ? maxDate : Long.MAX_VALUE);
        fragment.setArguments(args);
        return fragment;
    }

    public void setDateListener(DatePickerDialog.OnDateSetListener dateListener) {
        this.mDateListener = dateListener;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        long maxDate;
        Bundle theArguments = this.getArguments();
        int year = theArguments.getInt(KEY_YEAR);
        int month = theArguments.getInt(KEY_MONTH);
        int day = theArguments.getInt(KEY_DAY);
        DatePickerDialog theDatePickerDialog = new DatePickerDialog((Context)this.getActivity(), this.mDateListener, year, month, day);
        long minDate = theArguments.getLong(KEY_MIN_DATE);
        if (minDate != Long.MIN_VALUE) {
            theDatePickerDialog.getDatePicker().setMinDate(minDate);
        }
        if ((maxDate = theArguments.getLong(KEY_MAX_DATE)) != Long.MAX_VALUE) {
            theDatePickerDialog.getDatePicker().setMaxDate(maxDate);
        }
        return theDatePickerDialog;
    }
}

