package com.m14n.android.ex.anim;

import android.graphics.Camera;
import android.graphics.Matrix;
import android.view.animation.Animation;
import android.view.animation.Transformation;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class AroundAnimation extends Animation {
    private float centerX;
    private float centerY;
    private boolean onBackWay;
    private final List<Listener> listeners = new CopyOnWriteArrayList<Listener>();
    private final Camera camera = new Camera();
    private boolean vertical;

    public AroundAnimation() {
        super.setAnimationListener(new AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                for (AnimationListener listener : listeners) {
                    listener.onAnimationStart(animation);
                }
            }

            @Override
            public void onAnimationRepeat(Animation animation) {
                onBackWay = false;
                for (AnimationListener listener : listeners) {
                    listener.onAnimationRepeat(animation);
                }
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                for (AnimationListener listener : listeners) {
                    listener.onAnimationEnd(animation);
                }
            }
        });
    }

    @Override
    public void setAnimationListener(final AnimationListener listener) {
        throw new UnsupportedOperationException("This method is not supported. Use addListener(Listener) instead.");
    }

    public void setOrientation(boolean vertical) {
        this.vertical = vertical;
    }

    public void addListener(Listener listener) {
        listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        listeners.remove(listener);
    }

    private void notifyHalf() {
        for (Listener listener : listeners) {
            listener.onAnimationHalf(this);
        }
    }

    @Override
    public void initialize(int width, int height, int parentWidth, int parentHeight) {
        super.initialize(width, height, parentWidth, parentHeight);
        onBackWay = false;
        centerX = width / 2.0f;
        centerY = height / 2.0f;
    }

    @Override
    protected void applyTransformation(float interpolatedTime, Transformation t) {
        camera.save();
        final float angle = (onBackWay ? (interpolatedTime - 1) : interpolatedTime) * 180;
        if (!onBackWay && angle >= 90) {
            notifyHalf();
            onBackWay = true;
        }
        if (!vertical) {
            camera.rotateY(angle);
        } else {
            camera.rotateX(angle);
        }
        Matrix m = t.getMatrix();
        camera.getMatrix(m);
        camera.restore();
        m.preTranslate(-centerX, -centerY);
        m.postTranslate(centerX, centerY);
    }

    public interface Listener extends AnimationListener {
        void onAnimationHalf(Animation anim);
    }
}
