package com.m14n.android.ex;

import android.util.Log;

import java.util.Arrays;

public class Benchmark {
    private static final int BENCHMARK_NBR = 100;
    private static final boolean DEBUG = true;
    private static final String LOG_TAG = Benchmark.class.getSimpleName();
    private static final long DEFAULT = Long.MAX_VALUE;
    private static final long[] BENCHMARKS = new long[BENCHMARK_NBR];
    private static final String[] BENCHMARK_NAMES = new String[BENCHMARK_NBR];

    static {
        Arrays.fill(BENCHMARKS, DEFAULT);
    }

    public synchronized static int start(String name) {
        for (int i = 1; i < BENCHMARKS.length; i++) {
            if (BENCHMARKS[i] == DEFAULT) {
                BENCHMARK_NAMES[i] = name;
                if (DEBUG) {
                    Log.d(LOG_TAG, "Benchmark: START " + i + " " + name);
                }
                BENCHMARKS[i] = System.currentTimeMillis();
                return i;
            }
        }
        return -1;
    }

    public synchronized static void stop(int i) {
        final long time = System.currentTimeMillis() - BENCHMARKS[i];
        if (DEBUG) {
            Log.d(LOG_TAG, "Benchmark: END " + i + " " + BENCHMARK_NAMES[i] + " " + time + " ms.");
        }
        BENCHMARKS[i] = DEFAULT;
        BENCHMARK_NAMES[i] = null;
    }
}
