package com.m14n.android.ex;

import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;

public final class Alerts {
    /* package */static final String TITLE_KEY = "title";
    /* package */static final String MESSAGE_KEY = "message";

    private Alerts() {
    }

    public static void showOk(FragmentActivity activity, String tag, int titleId, int messageId) {
        show(activity, tag, titleId, messageId, android.R.string.ok, 0, 0);
    }

    public static void showOkCancel(FragmentActivity activity, String tag, int titleId, int messageId) {
        show(activity, tag, titleId, messageId, android.R.string.ok, 0, android.R.string.cancel);
    }

    public static void show(FragmentActivity activity, String tag, int titleId, int messageId, int positiveId,
            int neutralId, int negativeId) {
        final DialogFragment dialogFragment = AlertDialogFragment.create(titleId, messageId, positiveId, neutralId,
                negativeId);
        setAndShow(dialogFragment, activity, tag);
    }

    public static void showProgress(FragmentActivity activity, String tag, int titleId, int messageId) {
        final DialogFragment dialogFragment = ProgressDialogFragment.create(titleId, messageId);
        setAndShow(dialogFragment, activity, tag);
    }

    private static void setAndShow(DialogFragment dialogFragment, FragmentActivity activity, String tag) {
        dialogFragment.setCancelable(false);
        dialogFragment.show(activity.getSupportFragmentManager(), tag);
    }

    public static void close(FragmentActivity activity, String tag) {
        try {
            DialogFragment fragment = (DialogFragment) activity.getSupportFragmentManager().findFragmentByTag(tag);
            if (fragment != null) {
                fragment.dismiss();
            }
        } catch (ClassCastException e) {
            new IllegalArgumentException("The tag " + tag + " must be of DialogFragment!");
        }
    }
}
