package com.m14n.android.ex;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;

public class AlertDialogFragment extends DialogFragment {
    private static final String POSITIVE_KEY = "positive";
    private static final String NEUTRAL_KEY = "neutral";
    private static final String NEGATIVE_KEY = "negative";

    public static DialogFragment create(int titleId, int messageId, int positiveId, int neutralId, int negativeId) {
        if (positiveId == 0) {
            throw new IllegalArgumentException("The dialog must have positive button!");
        }
        DialogFragment fragment = new AlertDialogFragment();
        final Bundle args = new Bundle();
        args.putInt(Alerts.TITLE_KEY, titleId);
        args.putInt(Alerts.MESSAGE_KEY, messageId);
        args.putInt(POSITIVE_KEY, positiveId);
        args.putInt(NEUTRAL_KEY, neutralId);
        args.putInt(NEGATIVE_KEY, negativeId);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        final Activity activity = getActivity();
        final Bundle args = getArguments();
        final AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        final int titleId = args.getInt(Alerts.TITLE_KEY);
        if (titleId != 0) {
            builder.setTitle(titleId);
        }
        final int messageId = args.getInt(Alerts.MESSAGE_KEY);
        if (messageId != 0) {
            builder.setMessage(messageId);
        }
        final OnCloseDialogListener closeListener = activity instanceof OnCloseDialogListener ? (OnCloseDialogListener) activity
                : null;
        builder.setPositiveButton(args.getInt(POSITIVE_KEY), new ClickListener(OnCloseDialogListener.Result.POSITIVE, closeListener));
        final int neutralId = args.getInt(NEUTRAL_KEY);
        if (neutralId > 0) {
            builder.setNeutralButton(neutralId, new ClickListener(OnCloseDialogListener.Result.NEUTRAL, closeListener));
        }
        final int negativeId = args.getInt(NEGATIVE_KEY);
        if (negativeId > 0) {
            builder.setNegativeButton(negativeId, new ClickListener(OnCloseDialogListener.Result.NEGATIVE, closeListener));
        }
        return builder.setCancelable(false).create();
    }

    private class ClickListener implements DialogInterface.OnClickListener {
        private final OnCloseDialogListener.Result result;
        private final OnCloseDialogListener closeListener;

        public ClickListener(OnCloseDialogListener.Result result, OnCloseDialogListener closeListener) {
            this.result = result;
            this.closeListener = closeListener;
        }

        @Override
        public void onClick(DialogInterface dialog, int which) {
            dialog.cancel();
            if (closeListener != null) {
                closeListener.onClose(getTag(), result);
            }
        }
    }
}
