/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.UnsupportedEncodingException;
import org.apache.http.Header;

public class TextHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "TextHttpResponseHandler";

    public TextHttpResponseHandler() {
        this("UTF-8");
    }

    public TextHttpResponseHandler(String encoding) {
        this.setCharset(encoding);
    }

    public void onFailure(String responseBody, Throwable error) {
    }

    public void onFailure(int statusCode, Header[] headers, String responseBody, Throwable error) {
        this.onFailure(responseBody, error);
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, String responseBody) {
        this.onSuccess(statusCode, responseBody);
    }

    @Override
    public void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        try {
            String response = responseBody == null ? null : new String(responseBody, this.getCharset());
            this.onSuccess(statusCode, headers, response);
        }
        catch (UnsupportedEncodingException e) {
            Log.v((String)LOG_TAG, (String)"String encoding failed, calling onFailure(int, Header[], String, Throwable)");
            this.onFailure(0, headers, (String)null, (Throwable)e);
        }
    }

    @Override
    public void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        try {
            String response = responseBody == null ? null : new String(responseBody, this.getCharset());
            this.onFailure(statusCode, headers, response, error);
        }
        catch (UnsupportedEncodingException e) {
            Log.v((String)LOG_TAG, (String)"String encoding failed, calling onFailure(int, Header[], String, Throwable)");
            this.onFailure(0, headers, (String)null, (Throwable)e);
        }
    }
}

