/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.util.Log;
import com.loopj.android.http.TextHttpResponseHandler;
import org.apache.http.Header;

public abstract class BaseJsonHttpResponseHandler<JSON_TYPE>
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "BaseJsonHttpResponseHandler";

    public BaseJsonHttpResponseHandler() {
        super("UTF-8");
    }

    public BaseJsonHttpResponseHandler(String encoding) {
        super(encoding);
    }

    @Override
    public final void onSuccess(int statusCode, Header[] headers, byte[] responseBody) {
        super.onSuccess(statusCode, headers, responseBody);
    }

    @Override
    public final void onSuccess(String content) {
        super.onSuccess(content);
    }

    @Override
    public final void onSuccess(int statusCode, String content) {
        super.onSuccess(statusCode, content);
    }

    @Override
    public final void onFailure(String responseBody, Throwable error) {
        super.onFailure(responseBody, error);
    }

    @Override
    public final void onFailure(int statusCode, Header[] headers, byte[] responseBody, Throwable error) {
        super.onFailure(statusCode, headers, responseBody, error);
    }

    @Override
    public final void onFailure(Throwable error) {
        super.onFailure(error);
    }

    @Override
    public final void onFailure(Throwable error, String content) {
        super.onFailure(error, content);
    }

    @Override
    public final void onFailure(int statusCode, Throwable error, String content) {
        super.onFailure(statusCode, error, content);
    }

    @Override
    public final void onFailure(int statusCode, Header[] headers, Throwable error, String content) {
        super.onFailure(statusCode, headers, error, content);
    }

    public abstract void onSuccess(int var1, Header[] var2, String var3, JSON_TYPE var4);

    public abstract void onFailure(int var1, Header[] var2, Throwable var3, String var4, JSON_TYPE var5);

    @Override
    public void onSuccess(final int statusCode, final Header[] headers, final String responseBody) {
        if (statusCode != 204) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = BaseJsonHttpResponseHandler.this.parseResponse(responseBody);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onSuccess(statusCode, headers, responseBody, jsonResponse);
                            }
                        });
                    }
                    catch (Throwable t) {
                        Log.d((String)BaseJsonHttpResponseHandler.LOG_TAG, (String)"parseResponse thrown an problem", (Throwable)t);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, t, responseBody, null);
                            }
                        });
                    }
                }
            }).start();
        } else {
            this.onSuccess(statusCode, headers, null, null);
        }
    }

    @Override
    public void onFailure(final int statusCode, final Header[] headers, final String responseBody, final Throwable e) {
        if (responseBody != null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        final Object jsonResponse = BaseJsonHttpResponseHandler.this.parseResponse(responseBody);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, e, responseBody, jsonResponse);
                            }
                        });
                    }
                    catch (Throwable t) {
                        Log.d((String)BaseJsonHttpResponseHandler.LOG_TAG, (String)"parseResponse thrown an problem", (Throwable)t);
                        BaseJsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                BaseJsonHttpResponseHandler.this.onFailure(statusCode, headers, e, responseBody, null);
                            }
                        });
                    }
                }
            }).start();
        } else {
            this.onFailure(statusCode, headers, e, null, null);
        }
    }

    protected abstract JSON_TYPE parseResponse(String var1) throws Throwable;
}

