/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.adapter;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.RecyclerViewAdapter;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.utils.ImageDisplayHelper;
import java.util.List;

public class AlbumRecyclerAdapter
extends RecyclerViewAdapter<ImageFolder> {
    private ImageFolder mSelectFolder;
    private OnItemClickListener mOnItemClickListener;

    public AlbumRecyclerAdapter(Context context) {
        super(context);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        this.mOnItemClickListener = onItemClickListener;
    }

    @Override
    public void updateData(List<ImageFolder> data) {
        this.mSelectFolder = data.get(0);
        super.updateData(data);
    }

    @Override
    public void bindView(final ImageFolder var1, int var2, RecyclerView.ViewHolder var3, List<Object> payloads) {
        if (var3 instanceof AlbumViewHolder) {
            AlbumViewHolder albumViewHolder = (AlbumViewHolder)var3;
            albumViewHolder.bind(var1);
            albumViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AlbumRecyclerAdapter.this.onFolderSelected(var1);
                }
            });
            albumViewHolder.setFolderSelected(var1.equals(this.mSelectFolder));
        }
    }

    private void onFolderSelected(ImageFolder var1) {
        this.mSelectFolder = var1;
        this.mOnItemClickListener.onItemClick(var1);
        this.notifyDataSetChanged();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View view = this.getLayoutInflater().inflate(R.layout.list_item_album, parent, false);
        return new AlbumViewHolder(view);
    }

    static class AlbumViewHolder
    extends RecyclerView.ViewHolder {
        private SimpleDraweeView mImage;
        private TextView mTextAlbumName;
        private TextView mTextSize;
        private ImageView mSelectedIndicator;

        public AlbumViewHolder(View itemView) {
            super(itemView);
            this.mImage = (SimpleDraweeView)itemView.findViewById(R.id.image_album);
            this.mTextAlbumName = (TextView)itemView.findViewById(R.id.text_album_name);
            this.mTextSize = (TextView)itemView.findViewById(R.id.text_album_size);
            this.mSelectedIndicator = (ImageView)itemView.findViewById(R.id.image_album_selected_indicator);
            this.mSelectedIndicator.setColorFilter(ContextCompat.getColor((Context)itemView.getContext(), (int)R.color.image_group_theme_primary));
        }

        public void bind(ImageFolder imageFolder) {
            ImageDisplayHelper.displayImageLocal(this.mImage, imageFolder.firstImagePath, 200, 200);
            this.mTextAlbumName.setText((CharSequence)imageFolder.name);
            this.mTextSize.setText((CharSequence)Integer.toString(imageFolder.count));
        }

        public void setFolderSelected(boolean equals) {
            this.mSelectedIndicator.setVisibility(equals ? 0 : 8);
        }
    }

    public static interface OnItemClickListener {
        public void onItemClick(ImageFolder var1);
    }
}

