/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.activity;

import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.v7.app.AppCompatActivity;
import android.text.TextUtils;
import com.loopeer.android.librarys.imagegroupview.utils.FileUtils;
import com.loopeer.android.librarys.imagegroupview.utils.ImageGroupUtils;
import java.io.File;

public class UserCameraActivity
extends AppCompatActivity {
    private String photoUrl;
    private final String EXTRA_PHOTO_URL = "extra_photo_url";
    private final int RSULT_IMAGE_CAPTURE = 2002;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null) {
            this.photoUrl = savedInstanceState.getString("extra_photo_url");
            if (!TextUtils.isEmpty((CharSequence)this.photoUrl)) {
                this.recoverFile(this.photoUrl);
            }
        }
        if (savedInstanceState == null) {
            this.showCamera();
        }
    }

    private void recoverFile(String url) {
        String path = ImageGroupUtils.getPathOfPhotoByUri((Context)this, Uri.parse((String)url));
        try {
            if (!TextUtils.isEmpty((CharSequence)path) && FileUtils.fileIsAvaliableImage(new File(path))) {
                this.finishWithResult(url);
            } else {
                this.finishAfterDelete(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("extra_photo_url", this.photoUrl);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (2002 == requestCode && resultCode == -1) {
            this.finishWithResult(this.photoUrl);
        } else {
            this.finishAfterDelete(this.photoUrl);
        }
    }

    private void finishAfterDelete(String url) {
        String path = ImageGroupUtils.getPathOfPhotoByUri((Context)this, Uri.parse((String)url));
        if (!TextUtils.isEmpty((CharSequence)path)) {
            FileUtils.deleteFile(new File(path));
        }
        this.finish();
    }

    private void finishWithResult(String url) {
        Intent rsl = new Intent();
        rsl.putExtra("extra_photo_url", ImageGroupUtils.getPathOfPhotoByUri((Context)this, Uri.parse((String)url)));
        this.setResult(-1, rsl);
        this.finish();
    }

    private void showCamera() {
        Intent intent1 = new Intent("android.media.action.IMAGE_CAPTURE");
        ContentValues values = new ContentValues();
        Uri photoUri = this.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
        this.photoUrl = photoUri.toString();
        intent1.putExtra("output", (Parcelable)photoUri);
        this.startActivityForResult(intent1, 2002);
    }
}

