/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.util.AttributeSet;
import com.facebook.drawee.view.SimpleDraweeView;

public class ScaleImageView
extends SimpleDraweeView {
    private Matrix mMatrix;
    private static final float ZOOM_SCALE = 0.2f;
    private static final float REDUCE_SCALE = 0.0f;

    public ScaleImageView(Context context) {
        this(context, null);
    }

    public ScaleImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScaleImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    private void init() {
        this.mMatrix = new Matrix();
    }

    protected void onDraw(Canvas canvas) {
        canvas.concat(this.mMatrix);
        super.onDraw(canvas);
    }

    public void setScale(float scale) {
        this.mMatrix.setScale(1.0f + scale, 1.0f + scale, (float)(this.getMeasuredWidth() / 2), (float)(this.getMeasuredWidth() / 2));
        this.invalidate();
    }

    public static float getZoomScale() {
        return 0.2f;
    }

    public static float getReduceScale() {
        return 0.0f;
    }
}

