/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.view;

import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.AlbumRecyclerAdapter;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.utils.DisplayUtils;
import java.util.List;

public class CustomPopupView
extends LinearLayout
implements View.OnClickListener,
AlbumRecyclerAdapter.OnItemClickListener {
    private View mBgView;
    private RecyclerView mRecyclerView;
    private TextView mTextImagesNum;
    private AlbumRecyclerAdapter mFolderRecyclerAdaper;
    private boolean mIsShowing;
    private FolderItemSelectListener mFolderItemSelectListener;

    public CustomPopupView(Context context) {
        this(context, null);
    }

    public CustomPopupView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CustomPopupView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.view_popup_folder, (ViewGroup)this);
        this.mBgView = this.findViewById(R.id.view_album_popup_bg);
        this.mRecyclerView = (RecyclerView)this.findViewById(R.id.recycler_album_popup);
        this.mTextImagesNum = (TextView)this.findViewById(R.id.text_images_num);
        this.mFolderRecyclerAdaper = new AlbumRecyclerAdapter(this.getContext());
        this.mFolderRecyclerAdaper.setOnItemClickListener(this);
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mFolderRecyclerAdaper);
        this.mTextImagesNum.setOnClickListener((View.OnClickListener)this);
        this.mBgView.setOnClickListener((View.OnClickListener)this);
    }

    private void show() {
        this.mIsShowing = true;
        this.startShowWindowAnimation();
    }

    public void dismiss() {
        this.mIsShowing = false;
        this.startDismissWindowAnimation();
    }

    private boolean isShowing() {
        return this.mIsShowing;
    }

    private void togglePopupWindow() {
        if (this.isShowing()) {
            this.dismiss();
        } else {
            this.show();
        }
    }

    private void startShowWindowAnimation() {
        this.startShowAnimation(0, this.calculateWindowHeight(), true);
    }

    private void startDismissWindowAnimation() {
        this.startShowAnimation(this.calculateWindowHeight(), 0, false);
    }

    private void startShowAnimation(final int startHeight, final int endHeight, final boolean isShow) {
        ValueAnimator valueAnimator = ValueAnimator.ofInt((int[])new int[]{startHeight, endHeight});
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                int height = (Integer)animation.getAnimatedValue();
                if (height == startHeight && isShow) {
                    CustomPopupView.this.mRecyclerView.setVisibility(0);
                    CustomPopupView.this.mBgView.setVisibility(0);
                }
                CustomPopupView.this.setRecyclerViewHeight(height);
                CustomPopupView.this.setBgViewAlpha((float)height / (float)Math.abs(endHeight - startHeight));
                if (height == endHeight && !isShow) {
                    CustomPopupView.this.mRecyclerView.setVisibility(8);
                    CustomPopupView.this.mBgView.setVisibility(8);
                }
            }
        });
        valueAnimator.start();
    }

    private void setBgViewAlpha(float v) {
        this.mBgView.setAlpha(v);
    }

    private int getFooterHeight() {
        return this.mTextImagesNum.getHeight();
    }

    private void setRecyclerViewHeight(int height) {
        ViewGroup.LayoutParams params = this.mRecyclerView.getLayoutParams();
        params.height = height;
        this.mRecyclerView.setLayoutParams(params);
    }

    private int calculateWindowHeight() {
        int itemHeight = this.getResources().getDimensionPixelSize(R.dimen.image_select_folder_height);
        int actualHeight = this.mFolderRecyclerAdaper.getItemCount() * itemHeight;
        int maxPopupHeight = DisplayUtils.getScreenHeight(this.getContext()) * 5 / 8;
        return Math.min(maxPopupHeight, actualHeight);
    }

    public void setNumText(String str) {
        this.mTextImagesNum.setText((CharSequence)str);
    }

    public void updateFolderData(List list) {
        this.mFolderRecyclerAdaper.updateData(list);
        this.updateDefaultImages();
    }

    public void setFolderItemSelectListener(FolderItemSelectListener listener) {
        this.mFolderItemSelectListener = listener;
    }

    private void updateDefaultImages() {
        this.onItemSelect((ImageFolder)this.mFolderRecyclerAdaper.getItem(0));
    }

    private void onItemSelect(ImageFolder item) {
        this.mTextImagesNum.setText((CharSequence)item.name);
        this.dismiss();
        this.mFolderItemSelectListener.onFolderItemSelected(item);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.text_images_num) {
            this.togglePopupWindow();
        } else if (v.getId() == R.id.view_album_popup_bg) {
            this.dismiss();
        }
    }

    @Override
    public void onItemClick(ImageFolder imageFolder) {
        this.onItemSelect(imageFolder);
    }

    public static interface FolderItemSelectListener {
        public void onFolderItemSelected(ImageFolder var1);
    }
}

