/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import com.facebook.drawee.drawable.ScalingUtils;
import java.util.HashMap;
import java.util.Map;

public class AnimatorScaleType
implements ScalingUtils.ScaleType {
    public static AnimatorScaleType INSTANCE = new AnimatorScaleType();
    private static final String ZOOM = "zoom";
    private static final String REDUCE = "reduce";
    public static final float ZOOM_SCALE = 0.2f;
    public static final float REDUCE_SCALE = 0.0f;
    private static Map<String, AnimatorScaleType> POOL_INSTANCE = new HashMap<String, AnimatorScaleType>();
    private float mScale;

    public static AnimatorScaleType getZoomScaleType() {
        return POOL_INSTANCE.get(ZOOM);
    }

    public static AnimatorScaleType getReduceScaleType() {
        return POOL_INSTANCE.get(REDUCE);
    }

    private AnimatorScaleType() {
    }

    private AnimatorScaleType(float scale) {
        this.mScale = scale;
    }

    public void setScale(float scale) {
        this.mScale = scale;
    }

    public Matrix getTransform(Matrix outTransform, Rect parentRect, int childWidth, int childHeight, float focusX, float focusY) {
        float dy;
        float dx;
        float scale;
        float scaleX = (float)parentRect.width() / (float)childWidth;
        float scaleY = (float)parentRect.height() / (float)childHeight;
        if (scaleY > scaleX) {
            scale = scaleY;
            dx = (float)parentRect.left + ((float)parentRect.width() - (float)childWidth * scale) * 0.5f;
            dy = parentRect.top;
        } else {
            scale = scaleX;
            dx = parentRect.left;
            dy = (float)parentRect.top + ((float)parentRect.height() - (float)childHeight * scale) * 0.5f;
        }
        outTransform.setScale(scale, scale);
        outTransform.postTranslate((float)((int)(dx + 0.5f)), (float)((int)(dy + 0.5f)));
        outTransform.postScale(1.0f + this.mScale, 1.0f + this.mScale, (float)(parentRect.width() / 2), (float)(parentRect.height() / 2));
        return outTransform;
    }

    static {
        if (!POOL_INSTANCE.containsKey(ZOOM)) {
            POOL_INSTANCE.put(ZOOM, new AnimatorScaleType(0.2f));
        }
        if (!POOL_INSTANCE.containsKey(REDUCE)) {
            POOL_INSTANCE.put(REDUCE, new AnimatorScaleType(0.0f));
        }
    }
}

