/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.utils;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.support.v4.util.ArrayMap;
import android.util.Property;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import java.util.ArrayList;

public class AnimUtils {
    private static Interpolator fastOutSlowIn;
    private static Interpolator fastOutLinearIn;
    private static Interpolator linearOutSlowIn;

    private AnimUtils() {
    }

    public static Interpolator getFastOutSlowInInterpolator(Context context) {
        if (fastOutSlowIn == null) {
            fastOutSlowIn = AnimationUtils.loadInterpolator((Context)context, (int)17563661);
        }
        return fastOutSlowIn;
    }

    public static Interpolator getFastOutLinearInInterpolator(Context context) {
        if (fastOutLinearIn == null) {
            fastOutLinearIn = AnimationUtils.loadInterpolator((Context)context, (int)17563663);
        }
        return fastOutLinearIn;
    }

    public static Interpolator getLinearOutSlowInInterpolator(Context context) {
        if (linearOutSlowIn == null) {
            linearOutSlowIn = AnimationUtils.loadInterpolator((Context)context, (int)17563662);
        }
        return linearOutSlowIn;
    }

    public static float lerp(float a, float b, float t) {
        return a + (b - a) * t;
    }

    static class AnimatorListenerWrapper
    implements Animator.AnimatorListener {
        private final Animator mAnimator;
        private final Animator.AnimatorListener mListener;

        public AnimatorListenerWrapper(Animator animator, Animator.AnimatorListener listener) {
            this.mAnimator = animator;
            this.mListener = listener;
        }

        public void onAnimationStart(Animator animator) {
            this.mListener.onAnimationStart(this.mAnimator);
        }

        public void onAnimationEnd(Animator animator) {
            this.mListener.onAnimationEnd(this.mAnimator);
        }

        public void onAnimationCancel(Animator animator) {
            this.mListener.onAnimationCancel(this.mAnimator);
        }

        public void onAnimationRepeat(Animator animator) {
            this.mListener.onAnimationRepeat(this.mAnimator);
        }
    }

    public static class NoPauseAnimator
    extends Animator {
        private final Animator mAnimator;
        private final ArrayMap<Animator.AnimatorListener, Animator.AnimatorListener> mListeners = new ArrayMap();

        public NoPauseAnimator(Animator animator) {
            this.mAnimator = animator;
        }

        public void addListener(Animator.AnimatorListener listener) {
            AnimatorListenerWrapper wrapper = new AnimatorListenerWrapper(this, listener);
            if (!this.mListeners.containsKey((Object)listener)) {
                this.mListeners.put((Object)listener, (Object)wrapper);
                this.mAnimator.addListener((Animator.AnimatorListener)wrapper);
            }
        }

        public void cancel() {
            this.mAnimator.cancel();
        }

        public void end() {
            this.mAnimator.end();
        }

        public long getDuration() {
            return this.mAnimator.getDuration();
        }

        public TimeInterpolator getInterpolator() {
            return this.mAnimator.getInterpolator();
        }

        public void setInterpolator(TimeInterpolator timeInterpolator) {
            this.mAnimator.setInterpolator(timeInterpolator);
        }

        public ArrayList<Animator.AnimatorListener> getListeners() {
            return new ArrayList<Animator.AnimatorListener>(this.mListeners.keySet());
        }

        public long getStartDelay() {
            return this.mAnimator.getStartDelay();
        }

        public void setStartDelay(long delayMS) {
            this.mAnimator.setStartDelay(delayMS);
        }

        public boolean isPaused() {
            return this.mAnimator.isPaused();
        }

        public boolean isRunning() {
            return this.mAnimator.isRunning();
        }

        public boolean isStarted() {
            return this.mAnimator.isStarted();
        }

        public void removeAllListeners() {
            this.mListeners.clear();
            this.mAnimator.removeAllListeners();
        }

        public void removeListener(Animator.AnimatorListener listener) {
            Animator.AnimatorListener wrapper = (Animator.AnimatorListener)this.mListeners.get((Object)listener);
            if (wrapper != null) {
                this.mListeners.remove((Object)listener);
                this.mAnimator.removeListener(wrapper);
            }
        }

        public Animator setDuration(long durationMS) {
            this.mAnimator.setDuration(durationMS);
            return this;
        }

        public void setTarget(Object target) {
            this.mAnimator.setTarget(target);
        }

        public void setupEndValues() {
            this.mAnimator.setupEndValues();
        }

        public void setupStartValues() {
            this.mAnimator.setupStartValues();
        }

        public void start() {
            this.mAnimator.start();
        }
    }

    public static abstract class IntProperty<T>
    extends Property<T, Integer> {
        public IntProperty(String name) {
            super(Integer.class, name);
        }

        public abstract void setValue(T var1, int var2);

        public final void set(T object, Integer value) {
            this.setValue(object, value);
        }
    }

    public static abstract class FloatProperty<T>
    extends Property<T, Float> {
        public FloatProperty(String name) {
            super(Float.class, name);
        }

        public abstract void setValue(T var1, float var2);

        public final void set(T object, Float value) {
            this.setValue(object, value.floatValue());
        }
    }
}

