/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.android.librarys.imagegroupview.adapter;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.facebook.drawee.view.SimpleDraweeView;
import com.loopeer.android.librarys.imagegroupview.R;
import com.loopeer.android.librarys.imagegroupview.adapter.RecyclerViewAdapter;
import com.loopeer.android.librarys.imagegroupview.model.Image;
import com.loopeer.android.librarys.imagegroupview.model.ImageFolder;
import com.loopeer.android.librarys.imagegroupview.utils.ImageDisplayHelper;
import com.loopeer.android.librarys.imagegroupview.view.ScaleImageView;
import java.util.ArrayList;
import java.util.List;

public class ImageAdapter
extends RecyclerViewAdapter<Image> {
    private static final int ITEM_CAMERA = 10000;
    private static final int ITEM_IMAMGE = 10001;
    private static final int ANIMATOR_TIME = 600;
    private static final float ZOOM_IMAGE_SCALE = 0.2f;
    private static final float REDUCE_IMAGE_SCALE = 0.0f;
    private OnImageClickListener mOnImageClickListener;
    private List<Image> mSelectImages = new ArrayList<Image>();
    private int mAlbumType;

    public ImageAdapter(Context context) {
        super(context);
    }

    public void setOnImageClickListener(OnImageClickListener listener) {
        this.mOnImageClickListener = listener;
    }

    public void setAlbumType(int albumType) {
        this.mAlbumType = albumType;
    }

    @Override
    public void bindView(final Image product, final int i, RecyclerView.ViewHolder viewHolder, List<Object> payloads) {
        RecyclerView.ViewHolder productViewHolder;
        if (viewHolder instanceof ImageViewHolder) {
            productViewHolder = (ImageViewHolder)viewHolder;
            productViewHolder.bind(product, !payloads.isEmpty(), this.isImageSelected(product));
            productViewHolder.container.setOnClickListener(new View.OnClickListener((ImageViewHolder)productViewHolder){
                final /* synthetic */ ImageViewHolder val$productViewHolder;
                {
                    this.val$productViewHolder = imageViewHolder;
                }

                public void onClick(View v) {
                    int index = ImageAdapter.this.mOnImageClickListener.onImageSelected(product, i);
                    if (index == 1) {
                        ImageAdapter.this.showSelectedNumberAnimator((ViewGroup)this.val$productViewHolder.itemView);
                    }
                    if (index != 0) {
                        if (ImageAdapter.this.isImageSelected(product)) {
                            ImageAdapter.this.zoomImageScaleAnimator(this.val$productViewHolder.getImage());
                        } else {
                            ImageAdapter.this.reduceImageScaleAnimator(this.val$productViewHolder.getImage());
                        }
                    }
                }
            });
            productViewHolder.itemView.setSelected(this.isImageSelected(product));
        }
        if (viewHolder instanceof CameraViewHolder) {
            productViewHolder = (CameraViewHolder)viewHolder;
            productViewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ImageAdapter.this.mOnImageClickListener.onCameraSelected();
                }
            });
        }
    }

    private void zoomImageScaleAnimator(ScaleImageView draweeView) {
        this.getScaleAnimator(draweeView, 0.0f, 0.2f).start();
    }

    private void reduceImageScaleAnimator(ScaleImageView draweeView) {
        this.getScaleAnimator(draweeView, 0.2f, 0.0f).start();
    }

    private ValueAnimator getScaleAnimator(final ScaleImageView view, float from, float to) {
        ValueAnimator animator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        animator.setDuration(600L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                view.setScale(((Float)animation.getAnimatedValue()).floatValue());
            }
        });
        return animator;
    }

    private void showSelectedNumberAnimator(final ViewGroup view) {
        final TextView tv = new TextView(view.getContext());
        tv.setTextColor(-1);
        tv.setTextSize((float)this.getNumberAnimatorSize((View)view));
        tv.setText((CharSequence)String.valueOf(this.selectedImageNumber()));
        tv.setBackgroundColor(ContextCompat.getColor((Context)view.getContext(), (int)R.color.animator_text_bg));
        tv.setGravity(17);
        tv.setWidth(view.getWidth());
        tv.setHeight(view.getHeight());
        view.addView((View)tv, 1);
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)tv, (String)"alpha", (float[])new float[]{1.0f, 0.0f});
        animator.setDuration(600L);
        animator.setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator());
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                view.removeView((View)tv);
            }
        });
        animator.start();
    }

    private int getNumberAnimatorSize(View view) {
        return view.getWidth() / 9;
    }

    private int selectedImageNumber() {
        return this.mSelectImages.size();
    }

    private boolean isImageSelected(Image product) {
        return this.mSelectImages.contains(product);
    }

    public void updateFolderImageData(ImageFolder imageFolder) {
        ArrayList<Image> images = new ArrayList<Image>();
        images.addAll(imageFolder.images);
        if (TextUtils.isEmpty((CharSequence)imageFolder.dir) && this.mAlbumType != 2) {
            images.add(0, null);
        }
        this.updateData(images);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int i) {
        LayoutInflater inflater = this.getLayoutInflater();
        switch (i) {
            case 10000: {
                View view = inflater.inflate(R.layout.list_item_camera, parent, false);
                return new CameraViewHolder(view);
            }
        }
        View view = inflater.inflate(R.layout.list_item_image, parent, false);
        return new ImageViewHolder(view);
    }

    public int getItemViewType(int position) {
        if (this.getItem(position) == null) {
            return 10000;
        }
        return 10001;
    }

    public void updateSelectImages(List<Image> selectedImages, int position) {
        this.mSelectImages.clear();
        this.mSelectImages.addAll(selectedImages);
        this.notifyItemChanged(position, "make it not empty");
    }

    public static interface OnImageClickListener {
        public int onImageSelected(Image var1, int var2);

        public void onCameraSelected();
    }

    static class CameraViewHolder
    extends RecyclerView.ViewHolder {
        public CameraViewHolder(View itemView) {
            super(itemView);
            int screenWidth = itemView.getResources().getDisplayMetrics().widthPixels;
            int parentMargin = itemView.getResources().getDimensionPixelSize(R.dimen.inline_padding);
            int width = (screenWidth - parentMargin * 4) / 3;
            ViewGroup.LayoutParams layoutParams = itemView.getLayoutParams();
            layoutParams.height = width;
            layoutParams.width = width;
            itemView.setLayoutParams(layoutParams);
        }
    }

    static class ImageViewHolder
    extends RecyclerView.ViewHolder {
        ScaleImageView icon;
        FrameLayout container;
        private int mWidth;

        public ImageViewHolder(View itemView) {
            super(itemView);
            this.icon = (ScaleImageView)itemView.findViewById(16908294);
            this.container = (FrameLayout)itemView.findViewById(R.id.container);
            int screenWidth = itemView.getResources().getDisplayMetrics().widthPixels;
            int parentMargin = itemView.getResources().getDimensionPixelSize(R.dimen.inline_padding);
            this.mWidth = (screenWidth - parentMargin * 4) / 3;
            ViewGroup.LayoutParams layoutParams = this.icon.getLayoutParams();
            layoutParams.height = this.mWidth;
            layoutParams.width = this.mWidth;
            this.icon.setLayoutParams(layoutParams);
        }

        public ScaleImageView getImage() {
            return this.icon;
        }

        public void bind(Image image, boolean isDoAnimator, boolean isSelected) {
            ImageDisplayHelper.displayImageLocal((SimpleDraweeView)this.icon, image.url, this.mWidth, this.mWidth);
            if (!isDoAnimator) {
                this.icon.setScale(isSelected ? ScaleImageView.getZoomScale() : ScaleImageView.getReduceScale());
            }
        }
    }
}

