/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.cardstack;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.Observable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.OverScroller;
import com.loopeer.cardstack.AllMoveDownAnimatorAdapter;
import com.loopeer.cardstack.AnimatorAdapter;
import com.loopeer.cardstack.R;
import com.loopeer.cardstack.ScrollDelegate;
import com.loopeer.cardstack.StackAdapter;
import com.loopeer.cardstack.StackScrollDelegateImpl;
import com.loopeer.cardstack.UpDownAnimatorAdapter;
import com.loopeer.cardstack.UpDownStackAnimatorAdapter;
import java.util.ArrayList;
import java.util.List;

public class CardStackView
extends ViewGroup
implements ScrollDelegate {
    private static final int INVALID_POINTER = -1;
    public static final int INVALID_TYPE = -1;
    public static final int ANIMATION_STATE_START = 0;
    public static final int ANIMATION_STATE_END = 1;
    public static final int ANIMATION_STATE_CANCEL = 2;
    private static final String TAG = "CardStackView";
    public static final int ALL_DOWN = 0;
    public static final int UP_DOWN = 1;
    public static final int UP_DOWN_STACK = 2;
    static final int DEFAULT_SELECT_POSITION = -1;
    private int mTotalLength;
    private int mOverlapGaps;
    private int mOverlapGapsCollapse;
    private int mNumBottomShow;
    private StackAdapter mStackAdapter;
    private final ViewDataObserver mObserver = new ViewDataObserver();
    private int mSelectPosition = -1;
    private int mShowHeight;
    private List<ViewHolder> mViewHolders;
    private AnimatorAdapter mAnimatorAdapter;
    private int mDuration;
    private OverScroller mScroller;
    private int mLastMotionY;
    private boolean mIsBeingDragged = false;
    private VelocityTracker mVelocityTracker;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mActivePointerId = -1;
    private final int[] mScrollOffset = new int[2];
    private int mNestedYOffset;
    private boolean mScrollEnable = true;
    private ScrollDelegate mScrollDelegate;
    private ItemExpendListener mItemExpendListener;

    public CardStackView(Context context) {
        this(context, null);
    }

    public CardStackView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CardStackView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public CardStackView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.CardStackView, defStyleAttr, defStyleRes);
        this.setOverlapGaps(array.getDimensionPixelSize(R.styleable.CardStackView_stackOverlapGaps, this.dp2px(20)));
        this.setOverlapGapsCollapse(array.getDimensionPixelSize(R.styleable.CardStackView_stackOverlapGapsCollapse, this.dp2px(20)));
        this.setDuration(array.getInt(R.styleable.CardStackView_stackDuration, 400));
        this.setAnimationType(array.getInt(R.styleable.CardStackView_stackAnimationType, 2));
        this.setNumBottomShow(array.getInt(R.styleable.CardStackView_stackNumBottomShow, 3));
        array.recycle();
        this.mViewHolders = new ArrayList<ViewHolder>();
        this.initScroller();
    }

    private void initScroller() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
    }

    private int dp2px(int value) {
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        return (int)((float)value * scale + 0.5f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.checkContentHeightByParent();
        this.measureChild(widthMeasureSpec, heightMeasureSpec);
    }

    private void checkContentHeightByParent() {
        View parentView = (View)this.getParent();
        this.mShowHeight = parentView.getMeasuredHeight() - parentView.getPaddingTop() - parentView.getPaddingBottom();
    }

    private void measureChild(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = 0;
        this.mTotalLength = 0;
        this.mTotalLength += this.getPaddingTop() + this.getPaddingBottom();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            this.measureChildWithMargins(child, widthMeasureSpec, 0, heightMeasureSpec, 0);
            int totalLength = this.mTotalLength;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.mHeaderHeight == -1) {
                lp.mHeaderHeight = child.getMeasuredHeight();
            }
            int childHeight = lp.mHeaderHeight;
            this.mTotalLength = Math.max(totalLength, totalLength + childHeight + lp.topMargin + lp.bottomMargin);
            this.mTotalLength -= this.mOverlapGaps * 2;
            int margin = lp.leftMargin + lp.rightMargin;
            int measuredWidth = child.getMeasuredWidth() + margin;
            maxWidth = Math.max(maxWidth, measuredWidth);
        }
        this.mTotalLength += this.mOverlapGaps * 2;
        int heightSize = this.mTotalLength;
        heightSize = Math.max(heightSize, this.mShowHeight);
        int heightSizeAndState = CardStackView.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)0);
        this.setMeasuredDimension(CardStackView.resolveSizeAndState((int)maxWidth, (int)widthMeasureSpec, (int)0), heightSizeAndState);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        this.layoutChild();
    }

    private void layoutChild() {
        int childTop = this.getPaddingTop();
        int childLeft = this.getPaddingLeft();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            childTop += lp.topMargin;
            if (i != 0) {
                child.layout(childLeft, childTop -= this.mOverlapGaps * 2, childLeft + childWidth, childTop + childHeight);
            } else {
                child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
            }
            childTop += lp.mHeaderHeight;
        }
    }

    public void updateSelectPosition(final int selectPosition) {
        this.post(new Runnable(){

            @Override
            public void run() {
                CardStackView.this.doCardClickAnimation((ViewHolder)CardStackView.this.mViewHolders.get(selectPosition), selectPosition);
            }
        });
    }

    public void clearSelectPosition() {
        this.updateSelectPosition(this.mSelectPosition);
    }

    public void clearScrollYAndTranslation() {
        if (this.mSelectPosition != -1) {
            this.clearSelectPosition();
        }
        if (this.mScrollDelegate != null) {
            this.mScrollDelegate.setViewScrollY(0);
        }
        this.requestLayout();
    }

    public void setAdapter(StackAdapter stackAdapter) {
        this.mStackAdapter = stackAdapter;
        this.mStackAdapter.registerObserver(this.mObserver);
        this.refreshView();
    }

    public void setAnimationType(int type) {
        AnimatorAdapter animatorAdapter;
        switch (type) {
            case 0: {
                animatorAdapter = new AllMoveDownAnimatorAdapter(this);
                break;
            }
            case 1: {
                animatorAdapter = new UpDownAnimatorAdapter(this);
                break;
            }
            default: {
                animatorAdapter = new UpDownStackAnimatorAdapter(this);
            }
        }
        this.setAnimatorAdapter(animatorAdapter);
    }

    public void setAnimatorAdapter(AnimatorAdapter animatorAdapter) {
        this.clearScrollYAndTranslation();
        this.mAnimatorAdapter = animatorAdapter;
        this.mScrollDelegate = this.mAnimatorAdapter instanceof UpDownStackAnimatorAdapter ? new StackScrollDelegateImpl(this) : this;
    }

    private void refreshView() {
        this.removeAllViews();
        this.mViewHolders.clear();
        for (int i = 0; i < this.mStackAdapter.getItemCount(); ++i) {
            ViewHolder holder = this.getViewHolder(i);
            holder.position = i;
            holder.onItemExpand(i == this.mSelectPosition);
            this.addView(holder.itemView);
            this.setClickAnimator(holder, i);
            this.mStackAdapter.bindViewHolder(holder, i);
        }
        this.requestLayout();
    }

    ViewHolder getViewHolder(int i) {
        Object viewHolder;
        if (i == -1) {
            return null;
        }
        if (this.mViewHolders.size() <= i || this.mViewHolders.get((int)i).mItemViewType != this.mStackAdapter.getItemViewType(i)) {
            viewHolder = this.mStackAdapter.createView(this, this.mStackAdapter.getItemViewType(i));
            this.mViewHolders.add((ViewHolder)viewHolder);
        } else {
            viewHolder = this.mViewHolders.get(i);
        }
        return viewHolder;
    }

    private void setClickAnimator(final ViewHolder holder, int position) {
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CardStackView.this.mSelectPosition == -1) {
                    return;
                }
                CardStackView.this.performItemClick((ViewHolder)CardStackView.this.mViewHolders.get(CardStackView.this.mSelectPosition));
            }
        });
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CardStackView.this.performItemClick(holder);
            }
        });
    }

    public void next() {
        if (this.mSelectPosition == -1 || this.mSelectPosition == this.mViewHolders.size() - 1) {
            return;
        }
        this.performItemClick(this.mViewHolders.get(this.mSelectPosition + 1));
    }

    public void pre() {
        if (this.mSelectPosition == -1 || this.mSelectPosition == 0) {
            return;
        }
        this.performItemClick(this.mViewHolders.get(this.mSelectPosition - 1));
    }

    public boolean isExpending() {
        return this.mSelectPosition != -1;
    }

    public void performItemClick(ViewHolder viewHolder) {
        this.doCardClickAnimation(viewHolder, viewHolder.position);
    }

    private void doCardClickAnimation(ViewHolder viewHolder, int position) {
        this.checkContentHeightByParent();
        this.mAnimatorAdapter.itemClick(viewHolder, position);
    }

    private void initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (this.getViewScrollY() == 0 && !this.canScrollVertically(1)) {
            return false;
        }
        switch (action & 0xFF) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent"));
                    break;
                }
                int y = (int)ev.getY(pointerIndex);
                int yDiff = Math.abs(y - this.mLastMotionY);
                if (yDiff <= this.mTouchSlop) break;
                this.mIsBeingDragged = true;
                this.mLastMotionY = y;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                this.mNestedYOffset = 0;
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int y;
                this.mLastMotionY = y = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mIsBeingDragged = !this.mScroller.isFinished();
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                this.recycleVelocityTracker();
                if (!this.mScroller.springBack(this.getViewScrollX(), this.getViewScrollY(), 0, 0, 0, this.getScrollRange())) break;
                this.postInvalidate();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (!this.mScrollEnable) {
            this.mIsBeingDragged = false;
        }
        return this.mIsBeingDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (!this.mIsBeingDragged) {
            super.onTouchEvent(ev);
        }
        if (!this.mScrollEnable) {
            return true;
        }
        this.initVelocityTrackerIfNotExists();
        MotionEvent vtev = MotionEvent.obtain((MotionEvent)ev);
        int actionMasked = ev.getActionMasked();
        if (actionMasked == 0) {
            this.mNestedYOffset = 0;
        }
        vtev.offsetLocation(0.0f, (float)this.mNestedYOffset);
        switch (actionMasked) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionY = (int)ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e((String)TAG, (String)("Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent"));
                    break;
                }
                int y = (int)ev.getY(activePointerIndex);
                int deltaY = this.mLastMotionY - y;
                if (!this.mIsBeingDragged && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaY = deltaY > 0 ? (deltaY -= this.mTouchSlop) : (deltaY += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionY = y - this.mScrollOffset[1];
                int range = this.getScrollRange();
                if (this.mScrollDelegate instanceof StackScrollDelegateImpl) {
                    this.mScrollDelegate.scrollViewTo(0, deltaY + this.mScrollDelegate.getViewScrollY());
                    break;
                }
                if (!this.overScrollBy(0, deltaY, 0, this.getViewScrollY(), 0, range, 0, 0, true)) break;
                this.mVelocityTracker.clear();
                break;
            }
            case 1: {
                if (this.mIsBeingDragged) {
                    VelocityTracker velocityTracker = this.mVelocityTracker;
                    velocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    int initialVelocity = (int)velocityTracker.getYVelocity(this.mActivePointerId);
                    if (this.getChildCount() > 0) {
                        if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                            this.fling(-initialVelocity);
                        } else if (this.mScroller.springBack(this.getViewScrollX(), this.mScrollDelegate.getViewScrollY(), 0, 0, 0, this.getScrollRange())) {
                            this.postInvalidate();
                        }
                        this.mActivePointerId = -1;
                    }
                }
                this.endDrag();
                break;
            }
            case 3: {
                if (this.mIsBeingDragged && this.getChildCount() > 0) {
                    if (this.mScroller.springBack(this.getViewScrollX(), this.mScrollDelegate.getViewScrollY(), 0, 0, 0, this.getScrollRange())) {
                        this.postInvalidate();
                    }
                    this.mActivePointerId = -1;
                }
                this.endDrag();
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mLastMotionY = (int)ev.getY(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionY = (int)ev.getY(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(vtev);
        }
        vtev.recycle();
        return true;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private int getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            scrollRange = Math.max(0, this.mTotalLength - this.mShowHeight);
        }
        return scrollRange;
    }

    protected int computeVerticalScrollRange() {
        int count = this.getChildCount();
        int contentHeight = this.mShowHeight;
        if (count == 0) {
            return contentHeight;
        }
        int scrollRange = this.mTotalLength;
        int scrollY = this.mScrollDelegate.getViewScrollY();
        int overscrollBottom = Math.max(0, scrollRange - contentHeight);
        if (scrollY < 0) {
            scrollRange -= scrollY;
        } else if (scrollY > overscrollBottom) {
            scrollRange += scrollY - overscrollBottom;
        }
        return scrollRange;
    }

    protected void onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (!this.mScroller.isFinished()) {
            int oldX = this.mScrollDelegate.getViewScrollX();
            int oldY = this.mScrollDelegate.getViewScrollY();
            this.mScrollDelegate.setViewScrollX(scrollX);
            this.mScrollDelegate.setViewScrollY(scrollY);
            this.onScrollChanged(this.mScrollDelegate.getViewScrollX(), this.mScrollDelegate.getViewScrollY(), oldX, oldY);
            if (clampedY) {
                this.mScroller.springBack(this.mScrollDelegate.getViewScrollX(), this.mScrollDelegate.getViewScrollY(), 0, 0, 0, this.getScrollRange());
            }
        } else {
            super.scrollTo(scrollX, scrollY);
        }
    }

    protected int computeVerticalScrollOffset() {
        return Math.max(0, super.computeVerticalScrollOffset());
    }

    public void computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            this.mScrollDelegate.scrollViewTo(0, this.mScroller.getCurrY());
            this.postInvalidate();
        }
    }

    public void fling(int velocityY) {
        if (this.getChildCount() > 0) {
            int height = this.mShowHeight;
            int bottom = this.mTotalLength;
            this.mScroller.fling(this.mScrollDelegate.getViewScrollX(), this.mScrollDelegate.getViewScrollY(), 0, velocityY, 0, 0, 0, Math.max(0, bottom - height), 0, 0);
            this.postInvalidate();
        }
    }

    public void scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            x = CardStackView.clamp(x, this.getWidth() - this.getPaddingRight() - this.getPaddingLeft(), this.getWidth());
            y = CardStackView.clamp(y, this.mShowHeight, this.mTotalLength);
            if (x != this.mScrollDelegate.getViewScrollX() || y != this.mScrollDelegate.getViewScrollY()) {
                super.scrollTo(x, y);
            }
        }
    }

    @Override
    public int getViewScrollX() {
        return this.getScrollX();
    }

    @Override
    public void scrollViewTo(int x, int y) {
        this.scrollTo(x, y);
    }

    @Override
    public void setViewScrollY(int y) {
        this.setScrollY(y);
    }

    @Override
    public void setViewScrollX(int x) {
        this.setScrollX(x);
    }

    @Override
    public int getViewScrollY() {
        return this.getScrollY();
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.recycleVelocityTracker();
    }

    private static int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public int getSelectPosition() {
        return this.mSelectPosition;
    }

    public void setSelectPosition(int selectPosition) {
        this.mSelectPosition = selectPosition;
        this.mItemExpendListener.onItemExpend(this.mSelectPosition != -1);
    }

    public int getOverlapGaps() {
        return this.mOverlapGaps;
    }

    public void setOverlapGaps(int overlapGaps) {
        this.mOverlapGaps = overlapGaps;
    }

    public int getOverlapGapsCollapse() {
        return this.mOverlapGapsCollapse;
    }

    public void setOverlapGapsCollapse(int overlapGapsCollapse) {
        this.mOverlapGapsCollapse = overlapGapsCollapse;
    }

    public void setScrollEnable(boolean scrollEnable) {
        this.mScrollEnable = scrollEnable;
    }

    public int getShowHeight() {
        return this.mShowHeight;
    }

    public int getTotalLength() {
        return this.mTotalLength;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public int getDuration() {
        if (this.mAnimatorAdapter != null) {
            return this.mDuration;
        }
        return 0;
    }

    public void setNumBottomShow(int numBottomShow) {
        this.mNumBottomShow = numBottomShow;
    }

    public int getNumBottomShow() {
        return this.mNumBottomShow;
    }

    public ScrollDelegate getScrollDelegate() {
        return this.mScrollDelegate;
    }

    public ItemExpendListener getItemExpendListener() {
        return this.mItemExpendListener;
    }

    public void setItemExpendListener(ItemExpendListener itemExpendListener) {
        this.mItemExpendListener = itemExpendListener;
    }

    public static interface ItemExpendListener {
        public void onItemExpend(boolean var1);
    }

    private class ViewDataObserver
    extends AdapterDataObserver {
        private ViewDataObserver() {
        }

        @Override
        public void onChanged() {
            CardStackView.this.refreshView();
        }
    }

    public static abstract class AdapterDataObserver {
        public void onChanged() {
        }
    }

    public static class AdapterDataObservable
    extends Observable<AdapterDataObserver> {
        public boolean hasObservers() {
            return !this.mObservers.isEmpty();
        }

        public void notifyChanged() {
            for (int i = this.mObservers.size() - 1; i >= 0; --i) {
                ((AdapterDataObserver)this.mObservers.get(i)).onChanged();
            }
        }
    }

    public static abstract class ViewHolder {
        public View itemView;
        int mItemViewType = -1;
        int position;

        public ViewHolder(View view) {
            this.itemView = view;
        }

        public Context getContext() {
            return this.itemView.getContext();
        }

        public abstract void onItemExpand(boolean var1);

        protected void onAnimationStateChange(int state, boolean willBeSelect) {
        }
    }

    public static abstract class Adapter<VH extends ViewHolder> {
        private final AdapterDataObservable mObservable = new AdapterDataObservable();

        VH createView(ViewGroup parent, int viewType) {
            VH holder = this.onCreateView(parent, viewType);
            ((ViewHolder)holder).mItemViewType = viewType;
            return holder;
        }

        protected abstract VH onCreateView(ViewGroup var1, int var2);

        public void bindViewHolder(VH holder, int position) {
            this.onBindViewHolder(holder, position);
        }

        protected abstract void onBindViewHolder(VH var1, int var2);

        public abstract int getItemCount();

        public int getItemViewType(int position) {
            return 0;
        }

        public final void notifyDataSetChanged() {
            this.mObservable.notifyChanged();
        }

        public void registerObserver(AdapterDataObserver observer) {
            this.mObservable.registerObserver(observer);
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int mHeaderHeight;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray array = c.obtainStyledAttributes(attrs, R.styleable.CardStackView);
            this.mHeaderHeight = array.getDimensionPixelSize(R.styleable.CardStackView_stackHeaderHeight, -1);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

