/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.cardstack;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.util.Property;
import android.view.View;
import com.loopeer.cardstack.AnimatorAdapter;
import com.loopeer.cardstack.CardStackView;

public class UpDownStackAnimatorAdapter
extends AnimatorAdapter {
    public UpDownStackAnimatorAdapter(CardStackView cardStackView) {
        super(cardStackView);
    }

    @Override
    protected void itemExpandAnimatorSet(CardStackView.ViewHolder viewHolder, int position) {
        View itemView = viewHolder.itemView;
        itemView.clearAnimation();
        ObjectAnimator oa = ObjectAnimator.ofFloat((Object)itemView, (Property)View.Y, (float[])new float[]{itemView.getY(), this.mCardStackView.getChildAt(0).getY()});
        this.mSet.play((Animator)oa);
        int collapseShowItemCount = 0;
        for (int i = 0; i < this.mCardStackView.getChildCount(); ++i) {
            ObjectAnimator oAnim;
            if (i == this.mCardStackView.getSelectPosition()) continue;
            View child = this.mCardStackView.getChildAt(i);
            child.clearAnimation();
            if (i > this.mCardStackView.getSelectPosition() && collapseShowItemCount < this.mCardStackView.getNumBottomShow()) {
                int childTop = this.mCardStackView.getShowHeight() - this.getCollapseStartTop(collapseShowItemCount);
                oAnim = ObjectAnimator.ofFloat((Object)child, (Property)View.Y, (float[])new float[]{child.getY(), childTop});
                this.mSet.play((Animator)oAnim);
                ++collapseShowItemCount;
                continue;
            }
            if (i < this.mCardStackView.getSelectPosition()) {
                oAnim = ObjectAnimator.ofFloat((Object)child, (Property)View.Y, (float[])new float[]{child.getY(), this.mCardStackView.getChildAt(0).getY()});
                this.mSet.play((Animator)oAnim);
                continue;
            }
            oAnim = ObjectAnimator.ofFloat((Object)child, (Property)View.Y, (float[])new float[]{child.getY(), this.mCardStackView.getShowHeight()});
            this.mSet.play((Animator)oAnim);
        }
    }

    @Override
    protected void itemCollapseAnimatorSet(CardStackView.ViewHolder viewHolder) {
        int childTop = this.mCardStackView.getPaddingTop();
        for (int i = 0; i < this.mCardStackView.getChildCount(); ++i) {
            View child = this.mCardStackView.getChildAt(i);
            child.clearAnimation();
            CardStackView.LayoutParams lp = (CardStackView.LayoutParams)child.getLayoutParams();
            childTop += lp.topMargin;
            if (i != 0) {
                childTop -= this.mCardStackView.getOverlapGaps() * 2;
            }
            ObjectAnimator oAnim = ObjectAnimator.ofFloat((Object)child, (Property)View.Y, (float[])new float[]{child.getY(), (float)(childTop - this.mCardStackView.getScrollDelegate().getViewScrollY()) < this.mCardStackView.getChildAt(0).getY() ? this.mCardStackView.getChildAt(0).getY() : (float)(childTop - this.mCardStackView.getScrollDelegate().getViewScrollY())});
            this.mSet.play((Animator)oAnim);
            childTop += lp.mHeaderHeight;
        }
    }
}

