/*
 * Decompiled with CFR 0.152.
 */
package com.loopeer.cardstack;

import android.view.View;
import com.loopeer.cardstack.CardStackView;
import com.loopeer.cardstack.ScrollDelegate;

public class StackScrollDelegateImpl
implements ScrollDelegate {
    private CardStackView mCardStackView;
    private int mScrollY;
    private int mScrollX;

    public StackScrollDelegateImpl(CardStackView cardStackView) {
        this.mCardStackView = cardStackView;
    }

    private void updateChildPos() {
        for (int i = 0; i < this.mCardStackView.getChildCount(); ++i) {
            View view = this.mCardStackView.getChildAt(i);
            if ((float)(view.getTop() - this.mScrollY) < this.mCardStackView.getChildAt(0).getY()) {
                view.setTranslationY(this.mCardStackView.getChildAt(0).getY() - (float)view.getTop());
                continue;
            }
            if (view.getTop() - this.mScrollY > view.getTop()) {
                view.setTranslationY(0.0f);
                continue;
            }
            view.setTranslationY((float)(-this.mScrollY));
        }
    }

    @Override
    public void scrollViewTo(int x, int y) {
        x = StackScrollDelegateImpl.clamp(x, this.mCardStackView.getWidth() - this.mCardStackView.getPaddingRight() - this.mCardStackView.getPaddingLeft(), this.mCardStackView.getWidth());
        this.mScrollY = y = StackScrollDelegateImpl.clamp(y, this.mCardStackView.getShowHeight(), this.mCardStackView.getTotalLength());
        this.mScrollX = x;
        this.updateChildPos();
    }

    private static int clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    @Override
    public void setViewScrollY(int y) {
        this.scrollViewTo(this.mScrollX, y);
    }

    @Override
    public void setViewScrollX(int x) {
        this.scrollViewTo(x, this.mScrollY);
    }

    @Override
    public int getViewScrollY() {
        return this.mScrollY;
    }

    @Override
    public int getViewScrollX() {
        return this.mScrollX;
    }
}

